/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.metrics;

import java.util.HashSet;
import org.qubership.profiler.agent.Metric;
import org.qubership.profiler.agent.MetricType;
import org.qubership.profiler.metrics.AggregationParameter;
import org.qubership.profiler.metrics.MetricUnit;
import org.qubership.profiler.shaded.org.apache.commons.lang.StringUtils;

public abstract class AbstractMetric
implements Metric {
    protected String key;
    protected int outputVersion;
    private volatile long updatedTime;

    public AbstractMetric(String callType, MetricType type, HashSet<AggregationParameter> aggregationParameters, MetricUnit metricUnit, int outputVersion, String suffix) {
        this.outputVersion = outputVersion;
        this.key = this.buildKey(callType, type, aggregationParameters, metricUnit, suffix);
    }

    public AbstractMetric(String callType, MetricType type, HashSet<AggregationParameter> aggregationParameters, MetricUnit metricUnit, int outputVersion) {
        this(callType, type, aggregationParameters, metricUnit, outputVersion, null);
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public int getOutputVersion() {
        return this.outputVersion;
    }

    @Override
    public void setOutputVersion(int outputVersion) {
        this.outputVersion = outputVersion;
    }

    @Override
    public long getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public void resetUpdatedTime() {
        this.updatedTime = System.currentTimeMillis();
    }

    protected String buildKey(String callType, MetricType type, HashSet<AggregationParameter> aggregationParameters, MetricUnit metricUnit, String suffix) {
        if (this.outputVersion == 1) {
            return this.buildLegacyKey(callType, type, aggregationParameters, suffix);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(callType).append("_").append(type.getOutputName()).append("_").append(metricUnit.getOutputValue());
        if (!StringUtils.isEmpty(suffix)) {
            stringBuilder.append("_").append(suffix);
        }
        stringBuilder.append("{");
        if (!aggregationParameters.isEmpty()) {
            for (AggregationParameter aggregationParameter : aggregationParameters) {
                stringBuilder.append(aggregationParameter.toString()).append(", ");
            }
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    protected String buildKey(String callType, MetricType type, HashSet<AggregationParameter> aggregationParameters, MetricUnit metricUnit) {
        return this.buildKey(callType, type, aggregationParameters, metricUnit, null);
    }

    private String buildLegacyKey(String callType, MetricType type, HashSet<AggregationParameter> aggregationParameters, String suffix) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("esc_").append(type.getOutputName()).append("s");
        if (!StringUtils.isEmpty(suffix)) {
            stringBuilder.append("_").append(suffix);
        }
        stringBuilder.append("{type=\"").append(callType).append("\"");
        for (AggregationParameter aggregationParameter : aggregationParameters) {
            stringBuilder.append(", ").append(aggregationParameter.toString());
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMetric that = (AbstractMetric)o;
        if (this.updatedTime != that.updatedTime) {
            return false;
        }
        return this.key.equals(that.key);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + (int)(this.updatedTime ^ this.updatedTime >>> 32);
        return result;
    }
}

