/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.sax.builders;

import org.qubership.profiler.dom.ProfiledTreeStreamVisitor;
import org.qubership.profiler.io.SuspendLog;
import org.qubership.profiler.sax.builders.ClobValuesBuilder;
import org.qubership.profiler.sax.builders.DictionaryBuilder;
import org.qubership.profiler.sax.builders.MakeTreesFromTrace;
import org.qubership.profiler.sax.builders.SuspendLogBuilder;
import org.qubership.profiler.sax.raw.ClobValueVisitor;
import org.qubership.profiler.sax.raw.DictionaryVisitor;
import org.qubership.profiler.sax.raw.RepositoryVisitor;
import org.qubership.profiler.sax.raw.SuspendLogVisitor;
import org.qubership.profiler.sax.raw.TraceVisitor;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContext;

public class ProfiledTreeBuilder
extends RepositoryVisitor {
    private final ProfiledTreeStreamVisitor sv;
    private final DictionaryBuilder db;
    private final SuspendLogBuilder sb;
    private final ClobValuesBuilder cb;
    private final ApplicationContext context;

    public ProfiledTreeBuilder(ProfiledTreeStreamVisitor sv, int paramsTrimSize, ApplicationContext context, String rootReference) {
        this(1, sv, paramsTrimSize, context, rootReference);
    }

    protected ProfiledTreeBuilder(int api, ProfiledTreeStreamVisitor sv, int paramsTrimSize, ApplicationContext context, String rootReference) {
        super(api);
        this.sv = sv;
        this.context = context;
        this.db = new DictionaryBuilder();
        this.sb = context.getBean(SuspendLogBuilder.class, rootReference);
        this.cb = new ClobValuesBuilder(paramsTrimSize);
    }

    @Override
    public TraceVisitor visitTrace() {
        return new MakeTreesFromTrace(this.sv.asSkipVisitEnd(), this.db.get(), this.getSuspendLog(), this.cb.get());
    }

    @Override
    public SuspendLogVisitor visitSuspendLog() {
        return this.sb;
    }

    @Override
    public ClobValueVisitor visitClobValues() {
        return this.cb;
    }

    @Override
    public DictionaryVisitor visitDictionary() {
        return this.db;
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        this.sv.visitDictionaryReady();
        this.sv.visitEnd();
    }

    private SuspendLog getSuspendLog() {
        return this.sb.get();
    }
}

