/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.sax.readers;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.qubership.profiler.dump.DataInputStreamEx;
import org.qubership.profiler.io.exceptions.ErrorSupervisor;
import org.qubership.profiler.sax.raw.SuspendLogCollapsingVisitor;
import org.qubership.profiler.sax.raw.SuspendLogVisitor;
import org.qubership.profiler.sax.readers.SuspendPhraseReader;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Profile;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Scope;
import org.qubership.profiler.shaded.org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Profile(value={"filestorage"})
public class SuspendLogReader {
    public static final Logger log = LoggerFactory.getLogger(SuspendLogReader.class);
    protected final SuspendLogVisitor sv;
    private File dataFolder;
    private long begin;
    private long end;

    public SuspendLogReader(SuspendLogVisitor sv, String dataFolderPath, long begin, long end) {
        this.sv = sv;
        this.dataFolder = new File(dataFolderPath);
        this.begin = begin;
        this.end = end;
    }

    public SuspendLogReader(SuspendLogVisitor sv, String dataFolderPath) {
        this(sv, dataFolderPath, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public SuspendLogReader(SuspendLogVisitor sv) {
        this.sv = sv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() {
        DataInputStreamEx is = null;
        Enumeration<InputStream> inputStreams = this.openInputStream();
        while (inputStreams.hasMoreElements()) {
            try {
                is = new DataInputStreamEx(inputStreams.nextElement());
                long length = 1024L;
                if (is.contentLength() != null) {
                    length = is.contentLength();
                }
                this.read(is, length);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                ErrorSupervisor.getInstance().warn("Unable to open/read suspend log", t);
            }
            finally {
                this.sv.visitEnd();
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void read(DataInputStreamEx is, long fileSize) {
        block3: {
            SuspendLogVisitor sv = this.sv;
            if (fileSize > 0x100000L) {
                sv = new SuspendLogCollapsingVisitor(sv);
            }
            try {
                new SuspendPhraseReader(is, sv).parsingPhrases(Integer.MAX_VALUE, true, this.begin, this.end);
            }
            catch (IOException e) {
                if (e instanceof EOFException) break block3;
                ErrorSupervisor.getInstance().warn("Unable to read suspend log ", e);
            }
        }
    }

    protected Enumeration<InputStream> openInputStream() {
        try {
            return DataInputStreamEx.enumerateInputStreams(this.dataFolder, "suspend");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

