/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.security.csrf;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.qubership.profiler.shaded.org.apache.commons.lang.StringUtils;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;

public class CSRFGuardFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CSRFGuardFilter.class);

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpSession session;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String uri = request.getRequestURI();
        boolean redirected = this.checkCSRF(uri, request, response, session = request.getSession());
        if (!redirected) {
            filterChain.doFilter(request, response);
        }
    }

    private boolean checkCSRF(String uri, HttpServletRequest request, HttpServletResponse response, HttpSession session) throws IOException {
        if (request.getMethod().equalsIgnoreCase("GET")) {
            return false;
        }
        String tokenFromRequest = request.getParameter("CSRF_TOKEN");
        if (tokenFromRequest == null) {
            tokenFromRequest = request.getHeader("CSRF_TOKEN");
        }
        if (StringUtils.isEmpty(tokenFromRequest)) {
            log.error("CSRF token is empty for {} at {}", (Object)request.getMethod(), (Object)uri);
            this.redirect(response);
            return true;
        }
        Object csrfTokenObj = session.getAttribute("CSRF_TOKEN");
        if (csrfTokenObj == null) {
            log.error("The session does not contain CSRF token while client sent some for {} at {}", (Object)request.getMethod(), (Object)uri);
            this.redirect(response);
            return true;
        }
        String tokenValue_p = csrfTokenObj.toString();
        if (!tokenFromRequest.equals(tokenValue_p)) {
            log.error("CSRF token in request does not match the token stored in session, {} at {}", (Object)request.getMethod(), (Object)uri);
            this.redirect(response);
            return true;
        }
        return false;
    }

    private void redirect(ServletResponse response) throws IOException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.sendError(403);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

