/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.ch.qos.logback.access.net;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import org.qubership.profiler.shaded.ch.qos.logback.access.net.HardenedAccessEventInputStream;
import org.qubership.profiler.shaded.ch.qos.logback.access.spi.AccessContext;
import org.qubership.profiler.shaded.ch.qos.logback.access.spi.IAccessEvent;
import org.qubership.profiler.shaded.ch.qos.logback.core.spi.FilterReply;

public class SocketNode
implements Runnable {
    Socket socket;
    AccessContext context;
    HardenedAccessEventInputStream hardenedOIS;

    public SocketNode(Socket socket, AccessContext context) {
        this.socket = socket;
        this.context = context;
        try {
            this.hardenedOIS = new HardenedAccessEventInputStream(new BufferedInputStream(socket.getInputStream()));
        }
        catch (Exception e) {
            System.out.println("Could not open HardenedObjectInputStream to " + socket + e);
        }
    }

    @Override
    public void run() {
        try {
            IAccessEvent event;
            while (this.context.getFilterChainDecision(event = (IAccessEvent)this.hardenedOIS.readObject()) != FilterReply.DENY) {
                this.context.callAppenders(event);
            }
        }
        catch (EOFException e) {
            System.out.println("Caught java.io.EOFException closing connection.");
        }
        catch (SocketException e) {
            System.out.println("Caught java.net.SocketException closing connection.");
        }
        catch (IOException e) {
            System.out.println("Caught java.io.IOException: " + e);
            System.out.println("Closing connection.");
        }
        catch (Exception e) {
            System.out.println("Unexpected exception. Closing connection." + e);
        }
        try {
            this.hardenedOIS.close();
        }
        catch (Exception e) {
            System.out.println("Could not close connection." + e);
        }
    }
}

