/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.com.github.ziplet.filter.compression;

import java.io.Serializable;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.StatsField;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.statistics.CompressingFilterStats;

public class InputStatsCallback
implements Serializable {
    private static final long serialVersionUID = 8205059279453932247L;
    private final StatsField field;
    private final CompressingFilterStats stats;

    public InputStatsCallback(StatsField field, CompressingFilterStats stats) {
        this.field = field;
        this.stats = stats;
    }

    public void bytesRead(int numBytes) {
        assert (numBytes >= 0);
        switch (this.field) {
            case REQUEST_INPUT_BYTES: {
                this.stats.notifyRequestBytesRead(numBytes);
                break;
            }
            case REQUEST_COMPRESSED_BYTES: {
                this.stats.notifyCompressedRequestBytesRead(numBytes);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public String toString() {
        return "InputStatsCallback[field: " + this.field + ']';
    }
}

