/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.com.github.ziplet.filter.compression;

import java.io.IOException;
import java.io.InputStream;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.StatsField;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.statistics.CompressingFilterStats;

public class StatsInputStream
extends InputStream {
    protected final InputStream inputStream;
    protected final CompressingFilterStats stats;
    protected final StatsField field;

    public StatsInputStream(InputStream inputStream, CompressingFilterStats stats, StatsField field) {
        assert (inputStream != null && stats != null);
        this.inputStream = inputStream;
        this.stats = stats;
        this.field = field;
    }

    @Override
    public int read() throws IOException {
        int result = this.inputStream.read();
        this.notifyRequestBytesRead(1L);
        return result;
    }

    private void notifyRequestBytesRead(long result) {
        this.notifyBytesRead(result);
    }

    private void notifyBytesRead(long result) {
        if (result >= 0L) {
            switch (this.field) {
                case REQUEST_INPUT_BYTES: {
                    this.stats.notifyRequestBytesRead(result);
                    break;
                }
                case REQUEST_COMPRESSED_BYTES: {
                    this.stats.notifyCompressedRequestBytesRead(result);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = this.inputStream.read(b);
        this.notifyBytesRead(result);
        return result;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        int result = this.inputStream.read(b, offset, length);
        this.notifyBytesRead(result);
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    public String toString() {
        return "StatsInputStream[" + this.inputStream + ']';
    }
}

