/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.gnu.trove;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.qubership.profiler.shaded.gnu.trove.SerializationProcedure;
import org.qubership.profiler.shaded.gnu.trove.TDoubleHash;
import org.qubership.profiler.shaded.gnu.trove.TDoubleHashingStrategy;
import org.qubership.profiler.shaded.gnu.trove.TDoubleIterator;
import org.qubership.profiler.shaded.gnu.trove.TDoubleProcedure;

public class TDoubleHashSet
extends TDoubleHash
implements Externalizable {
    static final long serialVersionUID = 1L;

    public TDoubleHashSet() {
    }

    public TDoubleHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public TDoubleHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TDoubleHashSet(double[] array) {
        this(array.length);
        this.addAll(array);
    }

    public TDoubleHashSet(TDoubleHashingStrategy strategy) {
        super(strategy);
    }

    public TDoubleHashSet(int initialCapacity, TDoubleHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TDoubleHashSet(int initialCapacity, float loadFactor, TDoubleHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TDoubleHashSet(double[] array, TDoubleHashingStrategy strategy) {
        this(array.length, strategy);
        this.addAll(array);
    }

    public TDoubleIterator iterator() {
        return new TDoubleIterator(this);
    }

    public boolean add(double val) {
        int index = this.insertionIndex(val);
        if (index < 0) {
            return false;
        }
        byte previousState = this._states[index];
        this._set[index] = val;
        this._states[index] = 1;
        this.postInsertHook(previousState == 0);
        return true;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        double[] oldSet = this._set;
        byte[] oldStates = this._states;
        this._set = new double[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            double o = oldSet[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._states[index] = 1;
        }
    }

    public double[] toArray() {
        double[] result = new double[this.size()];
        double[] set = this._set;
        byte[] states = this._states;
        int i = states.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            result[j++] = set[i];
        }
        return result;
    }

    public void clear() {
        super.clear();
        double[] set = this._set;
        byte[] states = this._states;
        int i = set.length;
        while (i-- > 0) {
            set[i] = 0.0;
            states[i] = 0;
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof TDoubleHashSet)) {
            return false;
        }
        final TDoubleHashSet that = (TDoubleHashSet)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEach(new TDoubleProcedure(){

            public final boolean execute(double value) {
                return that.contains(value);
            }
        });
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEach(p);
        return p.getHashCode();
    }

    public boolean remove(double val) {
        int index = this.index(val);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public boolean containsAll(double[] array) {
        int i = array.length;
        while (i-- > 0) {
            if (this.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(double[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.add(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean removeAll(double[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.remove(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean retainAll(double[] array) {
        boolean changed = false;
        Arrays.sort(array);
        double[] set = this._set;
        byte[] states = this._states;
        int i = set.length;
        while (i-- > 0) {
            if (states[i] != 1 || Arrays.binarySearch(array, set[i]) >= 0) continue;
            this.remove(set[i]);
            changed = true;
        }
        return changed;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(out);
        if (!this.forEach(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        int size = in.readInt();
        this.setUp(size);
        while (size-- > 0) {
            double val = in.readDouble();
            this.add(val);
        }
    }

    private final class HashProcedure
    implements TDoubleProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(double key) {
            this.h += TDoubleHashSet.this._hashingStrategy.computeHashCode(key);
            return true;
        }
    }
}

