/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.common.unit;

import java.text.MessageFormat;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IMemberAccessor;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.messages.internal.Messages;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ContentType;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.DisplayFormatter;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.IFormatter;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.IQuantity;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.IRange;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.KindOfQuantity;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.QuantityRange;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.StructContentType;

public abstract class RangeContentType<T extends Comparable<? super T>>
extends StructContentType<IRange<T>> {
    private final ContentType<T> endPointType;

    static RangeContentType<IQuantity> create(KindOfQuantity<?> endPointType) {
        RangeContentType<IQuantity> rangeType = new RangeContentType<IQuantity>(endPointType, endPointType.getDeltaKind()){

            @Override
            public IRange<IQuantity> rangeWithEnd(IQuantity start, IQuantity end) {
                return QuantityRange.createWithEnd(start, end);
            }
        };
        for (String hint : new String[]{"auto", "exact", "verbose"}) {
            final IFormatter<IRange<IQuantity>> formatter = endPointType.getRangeFormatter(hint);
            if (formatter == null) continue;
            rangeType.addFormatter(new DisplayFormatter<IRange<IQuantity>>((ContentType)rangeType, hint, hint){

                @Override
                public String format(IRange<IQuantity> range) {
                    return formatter.format(range);
                }
            });
        }
        return rangeType;
    }

    static <T extends Comparable<? super T>> RangeContentType<T> create(ContentType<T> endPointType) {
        assert (!(endPointType instanceof KindOfQuantity));
        RangeContentType rangeType = new RangeContentType<T>((ContentType)endPointType, (ContentType)endPointType){

            @Override
            public IRange<T> rangeWithEnd(T start, T end) {
                throw new UnsupportedOperationException("Range creation not implemented");
            }
        };
        rangeType.addFormatter(new DisplayFormatter<IRange<T>>((ContentType)rangeType, "auto", "Value"){

            @Override
            public String format(IRange<T> o) {
                return o.displayUsing("auto");
            }
        });
        return rangeType;
    }

    private RangeContentType(ContentType<T> endPointType, ContentType<T> deltaType) {
        super(endPointType.getIdentifier() + "-range", MessageFormat.format(Messages.getString("RangeContentType_NAME"), endPointType.getName()));
        this.endPointType = endPointType;
        this.addField("start", endPointType, Messages.getString("RangeContentType_FIELD_START"), null, new IMemberAccessor<T, IRange<T>>(){

            @Override
            public T getMember(IRange<T> range) {
                return range.getStart();
            }
        });
        this.addField("end", endPointType, Messages.getString("RangeContentType_FIELD_END"), null, new IMemberAccessor<T, IRange<T>>(){

            @Override
            public T getMember(IRange<T> range) {
                return range.getEnd();
            }
        });
        this.addField("center", endPointType, Messages.getString("RangeContentType_FIELD_CENTER"), null, new IMemberAccessor<T, IRange<T>>(){

            @Override
            public T getMember(IRange<T> range) {
                return range.getCenter();
            }
        });
        this.addField("extent", deltaType, Messages.getString("RangeContentType_FIELD_EXTENT"), null, new IMemberAccessor<T, IRange<T>>(){

            @Override
            public T getMember(IRange<T> range) {
                return range.getExtent();
            }
        });
    }

    public abstract IRange<T> rangeWithEnd(T var1, T var2);

    public ContentType<T> getEndPointContentType() {
        return this.endPointType;
    }
}

