/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.common.util;

import javax.management.openmbean.CompositeData;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IMemberAccessor;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.IQuantity;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.IRange;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ITypedQuantity;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.QuantityRange;

public class MemberAccessorToolkit {
    public static <T> IMemberAccessor<IQuantity, T> difference(final IMemberAccessor<IQuantity, T> minuend, final IMemberAccessor<IQuantity, T> subtrahend) {
        return new IMemberAccessor<IQuantity, T>(){

            @Override
            public IQuantity getMember(T i) {
                IQuantity mv = (IQuantity)minuend.getMember(i);
                IQuantity sv = (IQuantity)subtrahend.getMember(i);
                return mv != null && sv != null ? mv.subtract(sv) : null;
            }
        };
    }

    public static <T> IMemberAccessor<IQuantity, T> sum(final IMemberAccessor<IQuantity, T> term1, final IMemberAccessor<IQuantity, T> term2) {
        return new IMemberAccessor<IQuantity, T>(){

            @Override
            public IQuantity getMember(T i) {
                IQuantity v1 = (IQuantity)term1.getMember(i);
                IQuantity v2 = (IQuantity)term2.getMember(i);
                return v1 != null && v2 != null ? v1.add(v2) : null;
            }
        };
    }

    public static <T> IMemberAccessor<IQuantity, T> avg(final IMemberAccessor<IQuantity, T> data1, final IMemberAccessor<IQuantity, T> data2) {
        return new IMemberAccessor<IQuantity, T>(){

            @Override
            public IQuantity getMember(T i) {
                IQuantity v1 = (IQuantity)data1.getMember(i);
                IQuantity v2 = (IQuantity)data2.getMember(i);
                return v1 != null && v2 != null ? v1.add(v2.subtract(v1).multiply(0.5)) : null;
            }
        };
    }

    public static <T> IMemberAccessor<IQuantity, T> addHalfDelta(final IMemberAccessor<IQuantity, T> bias, final IMemberAccessor<IQuantity, T> delta) {
        return new IMemberAccessor<IQuantity, T>(){

            @Override
            public IQuantity getMember(T i) {
                IQuantity v1 = (IQuantity)bias.getMember(i);
                IQuantity v2 = (IQuantity)delta.getMember(i);
                return v1 != null && v2 != null ? v1.add(v2.multiply(0.5)) : null;
            }
        };
    }

    public static <T> IMemberAccessor<IQuantity, T> subtractHalfDelta(final IMemberAccessor<IQuantity, T> bias, final IMemberAccessor<IQuantity, T> delta) {
        return new IMemberAccessor<IQuantity, T>(){

            @Override
            public IQuantity getMember(T i) {
                IQuantity v1 = (IQuantity)bias.getMember(i);
                IQuantity v2 = (IQuantity)delta.getMember(i);
                return v1 != null && v2 != null ? v1.subtract(v2.multiply(0.5)) : null;
            }
        };
    }

    public static <T> IMemberAccessor<IRange<IQuantity>, T> rangeWithEnd(final IMemberAccessor<IQuantity, T> start, final IMemberAccessor<IQuantity, T> end) {
        return new IMemberAccessor<IRange<IQuantity>, T>(){

            @Override
            public IRange<IQuantity> getMember(T i) {
                IQuantity vStart = (IQuantity)start.getMember(i);
                IQuantity vEnd = (IQuantity)end.getMember(i);
                return vStart != null && vEnd != null ? QuantityRange.createWithEnd(vStart, vEnd) : null;
            }
        };
    }

    public static <T> IMemberAccessor<IRange<IQuantity>, T> rangeWithExtent(final IMemberAccessor<IQuantity, T> start, final IMemberAccessor<IQuantity, T> extent) {
        return new IMemberAccessor<IRange<IQuantity>, T>(){

            @Override
            public IRange<IQuantity> getMember(T i) {
                IQuantity vStart = (IQuantity)start.getMember(i);
                ITypedQuantity vExtent = (ITypedQuantity)extent.getMember(i);
                return vStart != null && vExtent != null ? QuantityRange.createWithExtent(vStart, vExtent) : null;
            }
        };
    }

    public static <T> IMemberAccessor<IRange<IQuantity>, T> rangeWithExtentEnd(final IMemberAccessor<IQuantity, T> extent, final IMemberAccessor<IQuantity, T> end) {
        return new IMemberAccessor<IRange<IQuantity>, T>(){

            @Override
            public IRange<IQuantity> getMember(T i) {
                ITypedQuantity vExtent = (ITypedQuantity)extent.getMember(i);
                IQuantity vEnd = (IQuantity)end.getMember(i);
                return vEnd != null && vExtent != null ? QuantityRange.createWithExtent(vEnd.subtract(vExtent), vExtent) : null;
            }
        };
    }

    public static <T> IMemberAccessor<IRange<IQuantity>, T> pointRange(final IMemberAccessor<IQuantity, T> point) {
        return new IMemberAccessor<IRange<IQuantity>, T>(){

            @Override
            public IRange<IQuantity> getMember(T i) {
                IQuantity value = (IQuantity)point.getMember(i);
                return value != null ? QuantityRange.createPoint(value) : null;
            }
        };
    }

    public static <T, M, V extends M> IMemberAccessor<M, T> constant(final V value) {
        return new IMemberAccessor<M, T>(){

            @Override
            public M getMember(T inObject) {
                return value;
            }
        };
    }

    public static IMemberAccessor<?, Object[]> arrayElement(final int index) {
        return new IMemberAccessor<Object, Object[]>(){

            @Override
            public Object getMember(Object[] object) {
                return object[index];
            }
        };
    }

    public static IMemberAccessor<?, CompositeData> compositeElement(final String key) {
        return new IMemberAccessor<Object, CompositeData>(){

            @Override
            public Object getMember(CompositeData inObject) {
                return inObject.get(key);
            }
        };
    }
}

