/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.ConstantMap;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.factories.IPoolFactory;

class ConstantEntryList {
    private static final Comparator<ConstantEntry> CHRONOLOGICAL = new Comparator<ConstantEntry>(){

        @Override
        public int compare(ConstantEntry o1, ConstantEntry o2) {
            return o1.timestamp < o2.timestamp ? -1 : (o1.timestamp == o2.timestamp ? 0 : 1);
        }
    };
    private final IPoolFactory<?> factory;
    private final ConstantEntry firstEntry;
    private List<ConstantEntry> list;

    ConstantEntryList(Object firstValue, long timestamp, IPoolFactory<?> factory) {
        this.firstEntry = new ConstantEntry(firstValue, timestamp);
        this.factory = factory;
    }

    void add(Object value, long timestamp) {
        if (this.list == null) {
            this.list = new ArrayList<ConstantEntry>(5);
            this.list.add(this.firstEntry);
        }
        this.list.add(new ConstantEntry(value, timestamp));
    }

    void sort() {
        if (this.list != null) {
            Collections.sort(this.list, CHRONOLOGICAL);
        }
    }

    void touchAll(long objectIdOfThisEntry) {
        if (this.list == null) {
            this.firstEntry.getResolved(objectIdOfThisEntry);
        } else {
            for (ConstantEntry entry : this.list) {
                entry.getResolved(objectIdOfThisEntry);
            }
        }
    }

    Object getFirstObjectAfter(long objectIdOfThisEntry, long timestamp) {
        if (this.list == null) {
            return this.firstEntry.timestamp >= timestamp ? this.firstEntry.getResolved(objectIdOfThisEntry) : null;
        }
        for (ConstantEntry e : this.list) {
            if (e.timestamp < timestamp) continue;
            return e.getResolved(objectIdOfThisEntry);
        }
        return null;
    }

    private class ConstantEntry {
        Object value;
        long timestamp;
        byte resolveState;

        ConstantEntry(Object value, long timestamp) {
            this.value = value;
            this.timestamp = timestamp;
        }

        Object getResolved(long objectIdOfThisEntry) {
            switch (this.resolveState) {
                case 1: {
                    return null;
                }
                case 0: {
                    this.resolveState = 1;
                    this.value = ConstantMap.resolve(this.value, this.timestamp);
                    if (ConstantEntryList.this.factory != null) {
                        this.value = ConstantEntryList.this.factory.createObject(objectIdOfThisEntry, this.value);
                    }
                    this.resolveState = (byte)2;
                }
            }
            return this.value;
        }
    }
}

