/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0;

import java.util.HashMap;
import java.util.Map;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ContentType;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.ConstantEntryList;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.IValueReader;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.NumberReaders;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.Offset;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.factories.IPoolFactory;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.model.DataType;

class ConstantMap {
    private final Map<Key, ConstantEntryList> map = new HashMap<Key, ConstantEntryList>(17, 0.5f);
    private boolean allConstantsLoaded;
    private IPoolFactory<?> factory;
    private final Key lookupKey = new Key(0L);
    private IValueReader valueReader;
    private DataType keyType;

    ConstantMap() {
    }

    void init(IValueReader valueReader, DataType keyType, IPoolFactory<?> factory) {
        this.valueReader = valueReader;
        this.keyType = keyType;
        this.factory = factory;
    }

    void setLoadDone() throws InvalidJfrFileException {
        this.allConstantsLoaded = true;
        if (this.valueReader == null) {
            throw new InvalidJfrFileException();
        }
        for (ConstantEntryList entries : this.map.values()) {
            entries.sort();
        }
    }

    void touchAll() {
        for (Map.Entry<Key, ConstantEntryList> list : this.map.entrySet()) {
            list.getValue().touchAll(list.getKey().value);
        }
    }

    void readValue(byte[] data, Offset offset, long timestamp) throws InvalidJfrFileException {
        long key = NumberReaders.readKey(data, offset, this.keyType);
        this.put(key, this.valueReader.readValue(data, offset, timestamp), timestamp);
    }

    private void put(long valueId, Object value, long timestamp) {
        ConstantEntryList entries = this.getEntryList(valueId);
        if (entries == null) {
            entries = new ConstantEntryList(value, timestamp, this.factory);
            this.map.put(new Key(valueId), entries);
        } else {
            entries.add(value, timestamp);
        }
    }

    ContentType<?> getContentType() {
        return this.factory != null ? this.factory.getContentType() : this.valueReader.getValueType();
    }

    Object get(long valueId, long atTimestamp) {
        if (this.allConstantsLoaded) {
            ConstantEntryList entryList = this.getEntryList(valueId);
            if (entryList != null) {
                return entryList.getFirstObjectAfter(valueId, atTimestamp);
            }
            if (this.factory != null) {
                return this.factory.createObject(valueId, null);
            }
            return null;
        }
        return new Reference(valueId);
    }

    private ConstantEntryList getEntryList(long valueId) {
        this.lookupKey.value = valueId;
        return this.map.get(this.lookupKey);
    }

    static Object resolve(Object o, long atTimestamp) {
        if (o instanceof Reference) {
            return ConstantMap.resolve(((Reference)o).resolve(atTimestamp), atTimestamp);
        }
        if (o != null && o.getClass().isArray()) {
            Object[] array = (Object[])o;
            for (int n = 0; n < array.length; ++n) {
                array[n] = ConstantMap.resolve(array[n], atTimestamp);
            }
            return array;
        }
        return o;
    }

    private class Reference {
        private final long id;

        Reference(long id) {
            this.id = id;
        }

        Object resolve(long atTimestamp) {
            return ConstantMap.this.get(this.id, atTimestamp);
        }
    }

    private static final class Key {
        long value;

        Key(long value) {
            this.value = value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                return ((Key)object).value == this.value;
            }
            return false;
        }

        public String toString() {
            return Long.toString(this.value);
        }
    }
}

