/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.util.ChunkReader;

public class SplitRecording {
    private static final int MIB = 0x100000;

    public static void main(String[] args) throws IOException {
        File file;
        if (args.length == 0) {
            System.out.println("Usage:");
            System.out.println("java SplitRecording filename [targetSizePerFile in MiB]");
            System.out.println();
            System.out.println("Note that files will be aligned on chunk boundaries. The target size per file ");
            System.out.println("is a rough estimate. Files can be both larger and smaller than the set value. ");
            System.out.println("If no target size is specified, the file will be split into chunks.");
            System.exit(2);
        }
        if (!(file = new File(args[0])).exists()) {
            System.out.println("The specified file does not exist: " + args[0]);
            System.exit(3);
        }
        int targetSize = -1;
        if (args.length > 1) {
            targetSize = Integer.parseInt(args[1]) * 0x100000;
        }
        SplitRecording.split(file, targetSize);
    }

    private static void split(File file, int targetSize) throws IOException {
        System.out.println("Splitting " + file + "...");
        String namePattern = SplitRecording.getNamePatternFromFile(file);
        Iterator<byte[]> chunks = ChunkReader.readChunks(file);
        if (targetSize == -1) {
            System.out.println("No target size - will split along chunk borders");
            SplitRecording.writeAllChunks(namePattern, chunks);
        } else {
            System.out.println("Target size is " + targetSize / 0x100000 + " MiB");
            SplitRecording.writecCollatedChunks(targetSize, namePattern, chunks);
        }
        System.out.println("All done!");
    }

    private static void writecCollatedChunks(int targetSize, String namePattern, Iterator<byte[]> chunks) throws IOException {
        ArrayList<byte[]> writeList = new ArrayList<byte[]>();
        int writeCount = 0;
        int sum = 0;
        while (chunks.hasNext()) {
            byte[] nextChunk = chunks.next();
            if (sum != 0 && SplitRecording.distance(sum, targetSize) <= SplitRecording.distance(sum + nextChunk.length, targetSize)) {
                SplitRecording.writeChunks(writeCount++, writeList, namePattern);
                writeList.clear();
                sum = 0;
            }
            writeList.add(nextChunk);
            sum += nextChunk.length;
        }
    }

    private static void writeChunks(int i, List<byte[]> writeList, String namePattern) throws IOException {
        SplitRecording.writeChunks(SplitRecording.getFile(i, namePattern), writeList);
    }

    private static int distance(int sum, int targetSize) {
        return Math.abs(sum - targetSize);
    }

    private static void writeAllChunks(String namePattern, Iterator<byte[]> chunks) throws IOException {
        int i = 0;
        while (chunks.hasNext()) {
            SplitRecording.writeChunk(SplitRecording.getFile(i, namePattern), chunks.next());
            ++i;
        }
    }

    private static File getFile(int i, String namePattern) {
        return new File(String.format(namePattern, i));
    }

    private static String getNamePatternFromFile(File file) {
        String absolutePath = file.getAbsolutePath();
        String extension = SplitRecording.getExtension(file);
        absolutePath = absolutePath.substring(0, absolutePath.length() - extension.length());
        return absolutePath + "_%d" + extension;
    }

    private static void writeChunk(File file, byte[] chunk) throws IOException {
        System.out.print("Writing " + file.getName() + "... ");
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(chunk);
        }
        System.out.println("finished!");
    }

    private static void writeChunks(File file, List<byte[]> chunks) throws IOException {
        System.out.print(String.format("Writing %d chunk(s) to %s...", chunks.size(), file.getName()));
        try (FileOutputStream fos = new FileOutputStream(file);){
            for (byte[] chunk : chunks) {
                fos.write(chunk);
            }
        }
        System.out.println("finished!");
    }

    private static String getExtension(File file) {
        int index = file.getName().lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return file.getName().substring(index);
    }
}

