/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.spring.cache.CacheBuilder;
import com.couchbase.client.spring.cache.CouchbaseCacheManager;
import java.util.List;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache.CacheCondition;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache.CacheManagerCustomizers;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.qubership.profiler.shaded.org.springframework.cache.CacheManager;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Conditional;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Bucket.class, CouchbaseCacheManager.class})
@ConditionalOnMissingBean(value={CacheManager.class})
@ConditionalOnSingleCandidate(value=Bucket.class)
@Conditional(value={CacheCondition.class})
public class CouchbaseCacheConfiguration {
    private final CacheProperties cacheProperties;
    private final CacheManagerCustomizers customizers;
    private final Bucket bucket;

    public CouchbaseCacheConfiguration(CacheProperties cacheProperties, CacheManagerCustomizers customizers, Bucket bucket) {
        this.cacheProperties = cacheProperties;
        this.customizers = customizers;
        this.bucket = bucket;
    }

    @Bean
    public CouchbaseCacheManager cacheManager() {
        List<String> cacheNames = this.cacheProperties.getCacheNames();
        CouchbaseCacheManager cacheManager = new CouchbaseCacheManager(CacheBuilder.newInstance((Bucket)this.bucket).withExpiration(this.cacheProperties.getCouchbase().getExpirationSeconds()), cacheNames.toArray(new String[cacheNames.size()]));
        return this.customizers.customize(cacheManager);
    }
}

