/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.domain;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.BeanDefinition;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContext;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.qubership.profiler.shaded.org.springframework.core.type.filter.AnnotationTypeFilter;
import org.qubership.profiler.shaded.org.springframework.util.Assert;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;
import org.qubership.profiler.shaded.org.springframework.util.StringUtils;

public class EntityScanner {
    private final ApplicationContext context;

    public EntityScanner(ApplicationContext context) {
        Assert.notNull(context, "Context must not be null");
        this.context = context;
    }

    @SafeVarargs
    public final Set<Class<?>> scan(Class<? extends Annotation> ... annotationTypes) throws ClassNotFoundException {
        List<String> packages = this.getPackages();
        if (packages.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet entitySet = new HashSet();
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.setEnvironment(this.context.getEnvironment());
        scanner.setResourceLoader(this.context);
        for (Class<? extends Annotation> annotationType : annotationTypes) {
            scanner.addIncludeFilter(new AnnotationTypeFilter(annotationType));
        }
        for (String basePackage : packages) {
            if (!StringUtils.hasText(basePackage)) continue;
            for (BeanDefinition candidate : scanner.findCandidateComponents(basePackage)) {
                entitySet.add(ClassUtils.forName(candidate.getBeanClassName(), this.context.getClassLoader()));
            }
        }
        return entitySet;
    }

    private List<String> getPackages() {
        List<String> packages = EntityScanPackages.get(this.context).getPackageNames();
        if (packages.isEmpty() && AutoConfigurationPackages.has(this.context)) {
            packages = AutoConfigurationPackages.get(this.context);
        }
        return packages;
    }
}

