/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.h2;

import javax.servlet.Servlet;
import org.h2.server.web.WebServlet;
import org.qubership.profiler.shaded.org.springframework.beans.factory.annotation.Autowired;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.h2.H2ConsoleProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.security.SecurityAuthorizeMode;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.security.SecurityAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.core.annotation.Order;
import org.qubership.profiler.shaded.org.springframework.security.config.annotation.ObjectPostProcessor;
import org.qubership.profiler.shaded.org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.qubership.profiler.shaded.org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.qubership.profiler.shaded.org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={WebServlet.class})
@ConditionalOnProperty(prefix="spring.h2.console", name={"enabled"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={H2ConsoleProperties.class})
@AutoConfigureAfter(value={SecurityAutoConfiguration.class})
public class H2ConsoleAutoConfiguration {
    private final H2ConsoleProperties properties;

    public H2ConsoleAutoConfiguration(H2ConsoleProperties properties) {
        this.properties = properties;
    }

    @Bean
    public ServletRegistrationBean h2Console() {
        String path = this.properties.getPath();
        String urlMapping = path.endsWith("/") ? path + "*" : path + "/*";
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)new WebServlet(), urlMapping);
        H2ConsoleProperties.Settings settings = this.properties.getSettings();
        if (settings.isTrace()) {
            registration.addInitParameter("trace", "");
        }
        if (settings.isWebAllowOthers()) {
            registration.addInitParameter("webAllowOthers", "");
        }
        return registration;
    }

    @Configuration
    @ConditionalOnClass(value={WebSecurityConfigurerAdapter.class})
    @ConditionalOnBean(value={ObjectPostProcessor.class})
    @ConditionalOnProperty(prefix="security.basic", name={"enabled"}, matchIfMissing=true)
    static class H2ConsoleSecurityConfiguration {
        H2ConsoleSecurityConfiguration() {
        }

        @Bean
        public WebSecurityConfigurerAdapter h2ConsoleSecurityConfigurer() {
            return new H2ConsoleSecurityConfigurer();
        }

        @Order(value=0x7FFFFFF0)
        private static class H2ConsoleSecurityConfigurer
        extends WebSecurityConfigurerAdapter {
            @Autowired
            private H2ConsoleProperties console;
            @Autowired
            private SecurityProperties security;

            private H2ConsoleSecurityConfigurer() {
            }

            public void configure(HttpSecurity http) throws Exception {
                String path = this.console.getPath();
                String antPattern = path.endsWith("/") ? path + "**" : path + "/**";
                HttpSecurity h2Console = http.antMatcher(antPattern);
                h2Console.csrf().disable();
                h2Console.httpBasic();
                h2Console.headers().frameOptions().sameOrigin();
                String[] roles = this.security.getUser().getRole().toArray(new String[0]);
                SecurityAuthorizeMode mode = this.security.getBasic().getAuthorizeMode();
                if (mode == null || mode == SecurityAuthorizeMode.ROLE) {
                    ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).hasAnyRole(roles);
                } else if (mode == SecurityAuthorizeMode.AUTHENTICATED) {
                    ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).authenticated();
                }
            }
        }
    }
}

