/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.IOException;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.hazelcast.HazelcastConfigResourceCondition;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.hazelcast.HazelcastInstanceFactory;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.hazelcast.HazelcastProperties;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Conditional;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.core.io.Resource;

@Configuration
@ConditionalOnClass(value={HazelcastInstance.class})
@ConditionalOnMissingBean(value={HazelcastInstance.class})
@EnableConfigurationProperties(value={HazelcastProperties.class})
public class HazelcastAutoConfiguration {

    static class ConfigAvailableCondition
    extends HazelcastConfigResourceCondition {
        ConfigAvailableCondition() {
            super("spring.hazelcast", "config");
        }
    }

    @Configuration
    @ConditionalOnSingleCandidate(value=Config.class)
    static class HazelcastConfigConfiguration {
        HazelcastConfigConfiguration() {
        }

        @Bean
        public HazelcastInstance hazelcastInstance(Config config) {
            return new HazelcastInstanceFactory(config).getHazelcastInstance();
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={Config.class})
    @Conditional(value={ConfigAvailableCondition.class})
    static class HazelcastConfigFileConfiguration {
        private final HazelcastProperties hazelcastProperties;

        HazelcastConfigFileConfiguration(HazelcastProperties hazelcastProperties) {
            this.hazelcastProperties = hazelcastProperties;
        }

        @Bean
        public HazelcastInstance hazelcastInstance() throws IOException {
            Resource config = this.hazelcastProperties.resolveConfigLocation();
            if (config != null) {
                return new HazelcastInstanceFactory(config).getHazelcastInstance();
            }
            return Hazelcast.newHazelcastInstance();
        }
    }
}

