/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.info;

import java.io.IOException;
import java.util.Properties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.info.ProjectInfoProperties;
import org.qubership.profiler.shaded.org.springframework.boot.bind.RelaxedPropertyResolver;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.boot.info.BuildProperties;
import org.qubership.profiler.shaded.org.springframework.boot.info.GitProperties;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ConditionContext;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Conditional;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.core.env.Environment;
import org.qubership.profiler.shaded.org.springframework.core.io.DefaultResourceLoader;
import org.qubership.profiler.shaded.org.springframework.core.io.Resource;
import org.qubership.profiler.shaded.org.springframework.core.io.ResourceLoader;
import org.qubership.profiler.shaded.org.springframework.core.io.support.PropertiesLoaderUtils;
import org.qubership.profiler.shaded.org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@EnableConfigurationProperties(value={ProjectInfoProperties.class})
public class ProjectInfoAutoConfiguration {
    private final ProjectInfoProperties properties;

    public ProjectInfoAutoConfiguration(ProjectInfoProperties properties) {
        this.properties = properties;
    }

    @Conditional(value={GitResourceAvailableCondition.class})
    @ConditionalOnMissingBean
    @Bean
    public GitProperties gitProperties() throws Exception {
        return new GitProperties(this.loadFrom(this.properties.getGit().getLocation(), "git"));
    }

    @ConditionalOnResource(resources={"${spring.info.build.location:classpath:META-INF/build-info.properties}"})
    @ConditionalOnMissingBean
    @Bean
    public BuildProperties buildProperties() throws Exception {
        return new BuildProperties(this.loadFrom(this.properties.getBuild().getLocation(), "build"));
    }

    protected Properties loadFrom(Resource location, String prefix) throws IOException {
        String p = prefix.endsWith(".") ? prefix : prefix + ".";
        Properties source = PropertiesLoaderUtils.loadProperties(location);
        Properties target = new Properties();
        for (String key : source.stringPropertyNames()) {
            if (!key.startsWith(p)) continue;
            target.put(key.substring(p.length()), source.get(key));
        }
        return target;
    }

    static class GitResourceAvailableCondition
    extends SpringBootCondition {
        private final ResourceLoader defaultResourceLoader = new DefaultResourceLoader();

        GitResourceAvailableCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Environment propertyResolver;
            RelaxedPropertyResolver resolver;
            String location;
            ResourceLoader loader = context.getResourceLoader();
            if (loader == null) {
                loader = this.defaultResourceLoader;
            }
            if ((location = (resolver = new RelaxedPropertyResolver(propertyResolver = context.getEnvironment(), "spring.info.git.")).getProperty("location")) == null && (location = (resolver = new RelaxedPropertyResolver(propertyResolver, "spring.git.")).getProperty("properties")) == null) {
                location = "classpath:git.properties";
            }
            ConditionMessage.Builder message = ConditionMessage.forCondition("GitResource", new Object[0]);
            if (loader.getResource(location).exists()) {
                return ConditionOutcome.match(message.found("git info at").items(location));
            }
            return ConditionOutcome.noMatch(message.didNotFind("git info at").items(location));
        }
    }
}

