/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jms.artemis;

import java.io.File;
import org.qubership.profiler.shaded.org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.qubership.profiler.shaded.org.apache.activemq.artemis.core.config.Configuration;
import org.qubership.profiler.shaded.org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.qubership.profiler.shaded.org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.qubership.profiler.shaded.org.apache.activemq.artemis.core.server.JournalType;
import org.qubership.profiler.shaded.org.apache.commons.logging.Log;
import org.qubership.profiler.shaded.org.apache.commons.logging.LogFactory;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.jms.artemis.ArtemisProperties;

class ArtemisEmbeddedConfigurationFactory {
    private static final Log logger = LogFactory.getLog(ArtemisEmbeddedConfigurationFactory.class);
    private final ArtemisProperties.Embedded properties;

    ArtemisEmbeddedConfigurationFactory(ArtemisProperties properties) {
        this.properties = properties.getEmbedded();
    }

    public Configuration createConfiguration() {
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.setSecurityEnabled(false);
        configuration.setPersistenceEnabled(this.properties.isPersistent());
        String dataDir = this.getDataDir();
        configuration.setJournalDirectory(dataDir + "/journal");
        if (this.properties.isPersistent()) {
            configuration.setJournalType(JournalType.NIO);
            configuration.setLargeMessagesDirectory(dataDir + "/largemessages");
            configuration.setBindingsDirectory(dataDir + "/bindings");
            configuration.setPagingDirectory(dataDir + "/paging");
        }
        TransportConfiguration transportConfiguration = new TransportConfiguration(InVMAcceptorFactory.class.getName(), this.properties.generateTransportParameters());
        configuration.getAcceptorConfigurations().add(transportConfiguration);
        if (this.properties.isDefaultClusterPassword()) {
            logger.debug("Using default Artemis cluster password: " + this.properties.getClusterPassword());
        }
        configuration.setClusterPassword(this.properties.getClusterPassword());
        return configuration;
    }

    private String getDataDir() {
        if (this.properties.getDataDirectory() != null) {
            return this.properties.getDataDirectory();
        }
        String tempDirectory = System.getProperty("java.io.tmpdir");
        return new File(tempDirectory, "artemis-data").getAbsolutePath();
    }
}

