/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.mobile;

import java.util.List;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.mobile.DeviceResolverAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.mobile.device.site.SitePreferenceHandlerInterceptor;
import org.qubership.profiler.shaded.org.springframework.mobile.device.site.SitePreferenceHandlerMethodArgumentResolver;
import org.qubership.profiler.shaded.org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.qubership.profiler.shaded.org.springframework.web.servlet.HandlerInterceptor;
import org.qubership.profiler.shaded.org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.qubership.profiler.shaded.org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnClass(value={SitePreferenceHandlerInterceptor.class, SitePreferenceHandlerMethodArgumentResolver.class})
@AutoConfigureAfter(value={DeviceResolverAutoConfiguration.class})
@ConditionalOnProperty(prefix="spring.mobile.sitepreference", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnWebApplication
public class SitePreferenceAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={SitePreferenceHandlerInterceptor.class})
    public SitePreferenceHandlerInterceptor sitePreferenceHandlerInterceptor() {
        return new SitePreferenceHandlerInterceptor();
    }

    @Bean
    public SitePreferenceHandlerMethodArgumentResolver sitePreferenceHandlerMethodArgumentResolver() {
        return new SitePreferenceHandlerMethodArgumentResolver();
    }

    @Configuration
    protected static class SitePreferenceMvcConfiguration
    extends WebMvcConfigurerAdapter {
        private final SitePreferenceHandlerInterceptor sitePreferenceHandlerInterceptor;
        private final SitePreferenceHandlerMethodArgumentResolver sitePreferenceHandlerMethodArgumentResolver;

        protected SitePreferenceMvcConfiguration(SitePreferenceHandlerInterceptor sitePreferenceHandlerInterceptor, SitePreferenceHandlerMethodArgumentResolver sitePreferenceHandlerMethodArgumentResolver) {
            this.sitePreferenceHandlerInterceptor = sitePreferenceHandlerInterceptor;
            this.sitePreferenceHandlerMethodArgumentResolver = sitePreferenceHandlerMethodArgumentResolver;
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)this.sitePreferenceHandlerInterceptor);
        }

        public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
            argumentResolvers.add((HandlerMethodArgumentResolver)this.sitePreferenceHandlerMethodArgumentResolver);
        }
    }
}

