/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.orm.jpa;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.qubership.profiler.shaded.org.springframework.beans.BeansException;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanFactoryAware;
import org.qubership.profiler.shaded.org.springframework.beans.factory.ObjectProvider;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.orm.jpa.DataSourceInitializedPublisher;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Import;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Primary;
import org.qubership.profiler.shaded.org.springframework.orm.jpa.JpaTransactionManager;
import org.qubership.profiler.shaded.org.springframework.orm.jpa.JpaVendorAdapter;
import org.qubership.profiler.shaded.org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.qubership.profiler.shaded.org.springframework.orm.jpa.persistenceunit.PersistenceUnitManager;
import org.qubership.profiler.shaded.org.springframework.orm.jpa.support.OpenEntityManagerInViewFilter;
import org.qubership.profiler.shaded.org.springframework.orm.jpa.support.OpenEntityManagerInViewInterceptor;
import org.qubership.profiler.shaded.org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.qubership.profiler.shaded.org.springframework.transaction.PlatformTransactionManager;
import org.qubership.profiler.shaded.org.springframework.transaction.jta.JtaTransactionManager;
import org.qubership.profiler.shaded.org.springframework.web.context.request.WebRequestInterceptor;
import org.qubership.profiler.shaded.org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.qubership.profiler.shaded.org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@EnableConfigurationProperties(value={JpaProperties.class})
@Import(value={DataSourceInitializedPublisher.Registrar.class})
public abstract class JpaBaseConfiguration
implements BeanFactoryAware {
    private final DataSource dataSource;
    private final JpaProperties properties;
    private final JtaTransactionManager jtaTransactionManager;
    private final TransactionManagerCustomizers transactionManagerCustomizers;
    private ConfigurableListableBeanFactory beanFactory;

    protected JpaBaseConfiguration(DataSource dataSource, JpaProperties properties, ObjectProvider<JtaTransactionManager> jtaTransactionManager, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        this.dataSource = dataSource;
        this.properties = properties;
        this.jtaTransactionManager = jtaTransactionManager.getIfAvailable();
        this.transactionManagerCustomizers = transactionManagerCustomizers.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean(value={PlatformTransactionManager.class})
    public PlatformTransactionManager transactionManager() {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        if (this.transactionManagerCustomizers != null) {
            this.transactionManagerCustomizers.customize((PlatformTransactionManager)transactionManager);
        }
        return transactionManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public JpaVendorAdapter jpaVendorAdapter() {
        AbstractJpaVendorAdapter adapter = this.createJpaVendorAdapter();
        adapter.setShowSql(this.properties.isShowSql());
        adapter.setDatabase(this.properties.determineDatabase(this.dataSource));
        adapter.setDatabasePlatform(this.properties.getDatabasePlatform());
        adapter.setGenerateDdl(this.properties.isGenerateDdl());
        return adapter;
    }

    @Bean
    @ConditionalOnMissingBean
    public EntityManagerFactoryBuilder entityManagerFactoryBuilder(JpaVendorAdapter jpaVendorAdapter, ObjectProvider<PersistenceUnitManager> persistenceUnitManager) {
        EntityManagerFactoryBuilder builder = new EntityManagerFactoryBuilder(jpaVendorAdapter, this.properties.getProperties(), persistenceUnitManager.getIfAvailable());
        builder.setCallback(this.getVendorCallback());
        return builder;
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={LocalContainerEntityManagerFactoryBean.class, EntityManagerFactory.class})
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(EntityManagerFactoryBuilder factoryBuilder) {
        Map<String, Object> vendorProperties = this.getVendorProperties();
        this.customizeVendorProperties(vendorProperties);
        return factoryBuilder.dataSource(this.dataSource).packages(this.getPackagesToScan()).properties(vendorProperties).jta(this.isJta()).build();
    }

    protected abstract AbstractJpaVendorAdapter createJpaVendorAdapter();

    protected abstract Map<String, Object> getVendorProperties();

    protected void customizeVendorProperties(Map<String, Object> vendorProperties) {
    }

    protected EntityManagerFactoryBuilder.EntityManagerFactoryBeanCallback getVendorCallback() {
        return null;
    }

    protected String[] getPackagesToScan() {
        List<String> packages = EntityScanPackages.get(this.beanFactory).getPackageNames();
        if (packages.isEmpty() && AutoConfigurationPackages.has(this.beanFactory)) {
            packages = AutoConfigurationPackages.get(this.beanFactory);
        }
        return packages.toArray(new String[packages.size()]);
    }

    protected JtaTransactionManager getJtaTransactionManager() {
        return this.jtaTransactionManager;
    }

    protected final boolean isJta() {
        return this.jtaTransactionManager != null;
    }

    protected final JpaProperties getProperties() {
        return this.properties;
    }

    protected final DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    @Configuration
    @ConditionalOnWebApplication
    @ConditionalOnClass(value={WebMvcConfigurerAdapter.class})
    @ConditionalOnMissingBean(value={OpenEntityManagerInViewInterceptor.class, OpenEntityManagerInViewFilter.class})
    @ConditionalOnProperty(prefix="spring.jpa", name={"open-in-view"}, havingValue="true", matchIfMissing=true)
    protected static class JpaWebConfiguration {
        protected JpaWebConfiguration() {
        }

        @Configuration
        protected static class JpaWebMvcConfiguration
        extends WebMvcConfigurerAdapter {
            protected JpaWebMvcConfiguration() {
            }

            @Bean
            public OpenEntityManagerInViewInterceptor openEntityManagerInViewInterceptor() {
                return new OpenEntityManagerInViewInterceptor();
            }

            public void addInterceptors(InterceptorRegistry registry) {
                registry.addWebRequestInterceptor((WebRequestInterceptor)this.openEntityManagerInViewInterceptor());
            }
        }
    }
}

