/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.security.oauth2.method;

import org.qubership.profiler.shaded.org.springframework.beans.BeansException;
import org.qubership.profiler.shaded.org.springframework.beans.factory.BeanFactoryUtils;
import org.qubership.profiler.shaded.org.springframework.beans.factory.ListableBeanFactory;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.BeanPostProcessor;
import org.qubership.profiler.shaded.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContext;
import org.qubership.profiler.shaded.org.springframework.context.ApplicationContextAware;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.qubership.profiler.shaded.org.springframework.security.authentication.AuthenticationTrustResolver;
import org.qubership.profiler.shaded.org.springframework.security.config.annotation.method.configuration.GlobalMethodSecurityConfiguration;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.qubership.profiler.shaded.org.springframework.security.oauth2.provider.expression.OAuth2MethodSecurityExpressionHandler;

@Configuration
@ConditionalOnClass(value={OAuth2AccessToken.class})
@ConditionalOnBean(value={GlobalMethodSecurityConfiguration.class})
public class OAuth2MethodSecurityConfiguration
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        OAuth2ExpressionHandlerInjectionPostProcessor processor = new OAuth2ExpressionHandlerInjectionPostProcessor(this.applicationContext);
        beanFactory.addBeanPostProcessor(processor);
    }

    private static class OAuth2ExpressionHandlerInjectionPostProcessor
    implements BeanPostProcessor {
        private ApplicationContext applicationContext;

        OAuth2ExpressionHandlerInjectionPostProcessor(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        @Override
        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        @Override
        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof DefaultMethodSecurityExpressionHandler && !(bean instanceof OAuth2MethodSecurityExpressionHandler)) {
                return this.getExpressionHandler((DefaultMethodSecurityExpressionHandler)bean);
            }
            return bean;
        }

        private OAuth2MethodSecurityExpressionHandler getExpressionHandler(DefaultMethodSecurityExpressionHandler bean) {
            OAuth2MethodSecurityExpressionHandler handler = new OAuth2MethodSecurityExpressionHandler();
            handler.setApplicationContext(this.applicationContext);
            AuthenticationTrustResolver trustResolver = this.findInContext(AuthenticationTrustResolver.class);
            if (trustResolver != null) {
                handler.setTrustResolver(trustResolver);
            }
            handler.setExpressionParser(bean.getExpressionParser());
            return handler;
        }

        private <T> T findInContext(Class<T> type) {
            if (BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, type).length == 1) {
                return this.applicationContext.getBean(type);
            }
            return null;
        }
    }
}

