/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.session;

import com.hazelcast.core.HazelcastInstance;
import org.qubership.profiler.shaded.org.springframework.beans.factory.annotation.Autowired;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.session.SessionCondition;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.session.SessionProperties;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Conditional;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.session.SessionRepository;
import org.qubership.profiler.shaded.org.springframework.session.hazelcast.config.annotation.web.http.HazelcastHttpSessionConfiguration;

@Configuration
@ConditionalOnMissingBean(value={SessionRepository.class})
@ConditionalOnBean(value={HazelcastInstance.class})
@Conditional(value={SessionCondition.class})
class HazelcastSessionConfiguration {
    HazelcastSessionConfiguration() {
    }

    @Configuration
    public static class SpringBootHazelcastHttpSessionConfiguration
    extends HazelcastHttpSessionConfiguration {
        @Autowired
        public void customize(SessionProperties sessionProperties) {
            Integer timeout = sessionProperties.getTimeout();
            if (timeout != null) {
                this.setMaxInactiveIntervalInSeconds(timeout);
            }
            SessionProperties.Hazelcast hazelcast = sessionProperties.getHazelcast();
            this.setSessionMapName(hazelcast.getMapName());
            this.setHazelcastFlushMode(hazelcast.getFlushMode());
        }
    }
}

