/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.session;

import org.qubership.profiler.shaded.org.springframework.beans.factory.annotation.Autowired;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.session.SessionCondition;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.session.SessionProperties;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Conditional;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.data.redis.connection.RedisConnectionFactory;
import org.qubership.profiler.shaded.org.springframework.data.redis.core.RedisTemplate;
import org.qubership.profiler.shaded.org.springframework.session.SessionRepository;
import org.qubership.profiler.shaded.org.springframework.session.data.redis.config.annotation.web.http.RedisHttpSessionConfiguration;

@Configuration
@ConditionalOnMissingBean(value={SessionRepository.class})
@ConditionalOnBean(value={RedisTemplate.class, RedisConnectionFactory.class})
@Conditional(value={SessionCondition.class})
class RedisSessionConfiguration {
    RedisSessionConfiguration() {
    }

    @Configuration
    public static class SpringBootRedisHttpSessionConfiguration
    extends RedisHttpSessionConfiguration {
        private SessionProperties sessionProperties;

        @Autowired
        public void customize(SessionProperties sessionProperties) {
            this.sessionProperties = sessionProperties;
            Integer timeout = this.sessionProperties.getTimeout();
            if (timeout != null) {
                this.setMaxInactiveIntervalInSeconds(timeout);
            }
            SessionProperties.Redis redis = this.sessionProperties.getRedis();
            this.setRedisNamespace(redis.getNamespace());
            this.setRedisFlushMode(redis.getFlushMode());
        }
    }
}

