/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.solr;

import org.qubership.profiler.shaded.org.apache.solr.client.solrj.SolrClient;
import org.qubership.profiler.shaded.org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.qubership.profiler.shaded.org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.solr.SolrProperties;
import org.qubership.profiler.shaded.org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={HttpSolrClient.class, CloudSolrClient.class})
@EnableConfigurationProperties(value={SolrProperties.class})
public class SolrAutoConfiguration {
    private final SolrProperties properties;
    private SolrClient solrClient;

    public SolrAutoConfiguration(SolrProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public SolrClient solrClient() {
        this.solrClient = this.createSolrClient();
        return this.solrClient;
    }

    private SolrClient createSolrClient() {
        if (StringUtils.hasText(this.properties.getZkHost())) {
            return new CloudSolrClient(this.properties.getZkHost());
        }
        return new HttpSolrClient(this.properties.getHost());
    }
}

