/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.websocket;

import io.undertow.websockets.jsr.Bootstrap;
import javax.servlet.Servlet;
import javax.websocket.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.qubership.profiler.shaded.org.apache.catalina.startup.Tomcat;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnJava;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.websocket.JettyWebSocketContainerCustomizer;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.websocket.TomcatWebSocketContainerCustomizer;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.websocket.UndertowWebSocketContainerCustomizer;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Servlet.class, ServerContainer.class})
@ConditionalOnWebApplication
@AutoConfigureBefore(value={EmbeddedServletContainerAutoConfiguration.class})
public class WebSocketAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={Bootstrap.class})
    static class UndertowWebSocketConfiguration {
        UndertowWebSocketConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"websocketContainerCustomizer"})
        public UndertowWebSocketContainerCustomizer websocketContainerCustomizer() {
            return new UndertowWebSocketContainerCustomizer();
        }
    }

    @Configuration
    @ConditionalOnClass(value={WebSocketServerContainerInitializer.class})
    static class JettyWebSocketConfiguration {
        JettyWebSocketConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"websocketContainerCustomizer"})
        public JettyWebSocketContainerCustomizer websocketContainerCustomizer() {
            return new JettyWebSocketContainerCustomizer();
        }
    }

    @Configuration
    @ConditionalOnClass(name={"org.qubership.profiler.shaded.org.apache.tomcat.websocket.server.WsSci"}, value={Tomcat.class})
    static class TomcatWebSocketConfiguration {
        TomcatWebSocketConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"websocketContainerCustomizer"})
        @ConditionalOnJava(value=ConditionalOnJava.JavaVersion.SEVEN)
        public TomcatWebSocketContainerCustomizer websocketContainerCustomizer() {
            return new TomcatWebSocketContainerCustomizer();
        }
    }
}

