/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.context.embedded;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.util.Arrays;
import org.qubership.profiler.shaded.org.apache.commons.logging.Log;
import org.qubership.profiler.shaded.org.apache.commons.logging.LogFactory;
import org.qubership.profiler.shaded.org.springframework.boot.ApplicationHome;
import org.qubership.profiler.shaded.org.springframework.boot.ApplicationTemp;
import org.qubership.profiler.shaded.org.springframework.boot.context.embedded.AbstractConfigurableEmbeddedServletContainer;
import org.qubership.profiler.shaded.org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.qubership.profiler.shaded.org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.qubership.profiler.shaded.org.springframework.util.Assert;

public abstract class AbstractEmbeddedServletContainerFactory
extends AbstractConfigurableEmbeddedServletContainer
implements EmbeddedServletContainerFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final String[] COMMON_DOC_ROOTS = new String[]{"src/main/webapp", "public", "static"};

    public AbstractEmbeddedServletContainerFactory() {
    }

    public AbstractEmbeddedServletContainerFactory(int port) {
        super(port);
    }

    public AbstractEmbeddedServletContainerFactory(String contextPath, int port) {
        super(contextPath, port);
    }

    protected final File getValidDocumentRoot() {
        File file = this.getDocumentRoot();
        file = file != null ? file : this.getWarFileDocumentRoot();
        file = file != null ? file : this.getExplodedWarFileDocumentRoot();
        File file2 = file = file != null ? file : this.getCommonDocumentRoot();
        if (file == null && this.logger.isDebugEnabled()) {
            this.logger.debug("None of the document roots " + Arrays.asList(COMMON_DOC_ROOTS) + " point to a directory and will be ignored.");
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Document root: " + file);
        }
        return file;
    }

    private File getExplodedWarFileDocumentRoot() {
        return this.getExplodedWarFileDocumentRoot(this.getCodeSourceArchive());
    }

    File getExplodedWarFileDocumentRoot(File codeSourceFile) {
        String path;
        int webInfPathIndex;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Code archive: " + codeSourceFile);
        }
        if (codeSourceFile != null && codeSourceFile.exists() && (webInfPathIndex = (path = codeSourceFile.getAbsolutePath()).indexOf(File.separatorChar + "WEB-INF" + File.separatorChar)) >= 0) {
            path = path.substring(0, webInfPathIndex);
            return new File(path);
        }
        return null;
    }

    private File getWarFileDocumentRoot() {
        return this.getArchiveFileDocumentRoot(".war");
    }

    private File getArchiveFileDocumentRoot(String extension) {
        File file = this.getCodeSourceArchive();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Code archive: " + file);
        }
        if (file != null && file.exists() && !file.isDirectory() && file.getName().toLowerCase().endsWith(extension)) {
            return file.getAbsoluteFile();
        }
        return null;
    }

    private File getCommonDocumentRoot() {
        for (String commonDocRoot : COMMON_DOC_ROOTS) {
            File root = new File(commonDocRoot);
            if (!root.exists() || !root.isDirectory()) continue;
            return root.getAbsoluteFile();
        }
        return null;
    }

    private File getCodeSourceArchive() {
        try {
            URL location;
            CodeSource codeSource = this.getClass().getProtectionDomain().getCodeSource();
            URL uRL = location = codeSource == null ? null : codeSource.getLocation();
            if (location == null) {
                return null;
            }
            String path = location.getPath();
            URLConnection connection = location.openConnection();
            if (connection instanceof JarURLConnection) {
                path = ((JarURLConnection)connection).getJarFile().getName();
            }
            if (path.indexOf("!/") != -1) {
                path = path.substring(0, path.indexOf("!/"));
            }
            return new File(path);
        }
        catch (IOException ex) {
            return null;
        }
    }

    protected final File getValidSessionStoreDir() {
        return this.getValidSessionStoreDir(true);
    }

    protected final File getValidSessionStoreDir(boolean mkdirs) {
        File dir = this.getSessionStoreDir();
        if (dir == null) {
            return new ApplicationTemp().getDir("servlet-sessions");
        }
        if (!dir.isAbsolute()) {
            dir = new File(new ApplicationHome().getDir(), dir.getPath());
        }
        if (!dir.exists() && mkdirs) {
            dir.mkdirs();
        }
        Assert.state(!mkdirs || dir.exists(), "Session dir " + dir + " does not exist");
        Assert.state(!dir.isFile(), "Session dir " + dir + " points to a file");
        return dir;
    }

    protected File createTempDir(String prefix) {
        try {
            File tempDir = File.createTempFile(prefix + ".", "." + this.getPort());
            tempDir.delete();
            tempDir.mkdir();
            tempDir.deleteOnExit();
            return tempDir;
        }
        catch (IOException ex) {
            throw new EmbeddedServletContainerException("Unable to create tempDir. java.io.tmpdir is set to " + System.getProperty("java.io.tmpdir"), ex);
        }
    }
}

