/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.json;

import java.util.List;
import java.util.Map;
import org.qubership.profiler.shaded.com.google.gson.Gson;
import org.qubership.profiler.shaded.com.google.gson.GsonBuilder;
import org.qubership.profiler.shaded.com.google.gson.reflect.TypeToken;
import org.qubership.profiler.shaded.org.springframework.boot.json.JsonParser;

public class GsonJsonParser
implements JsonParser {
    private static final TypeToken<?> MAP_TYPE = new MapTypeToken();
    private static final TypeToken<?> LIST_TYPE = new ListTypeToken();
    private Gson gson = new GsonBuilder().create();

    @Override
    public Map<String, Object> parseMap(String json) {
        if (json != null && (json = json.trim()).startsWith("{")) {
            return (Map)this.gson.fromJson(json, MAP_TYPE.getType());
        }
        throw new IllegalArgumentException("Cannot parse JSON");
    }

    @Override
    public List<Object> parseList(String json) {
        if (json != null && (json = json.trim()).startsWith("[")) {
            return (List)this.gson.fromJson(json, LIST_TYPE.getType());
        }
        throw new IllegalArgumentException("Cannot parse JSON");
    }

    private static final class ListTypeToken
    extends TypeToken<List<Object>> {
        private ListTypeToken() {
        }
    }

    private static final class MapTypeToken
    extends TypeToken<Map<String, Object>> {
        private MapTypeToken() {
        }
    }
}

