/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.json;

import java.util.List;
import java.util.Map;
import org.qubership.profiler.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.qubership.profiler.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.qubership.profiler.shaded.org.springframework.boot.json.JsonParser;

public class JacksonJsonParser
implements JsonParser {
    private static final TypeReference<?> MAP_TYPE = new MapTypeReference();
    private static final TypeReference<?> LIST_TYPE = new ListTypeReference();
    private ObjectMapper objectMapper;

    @Override
    public Map<String, Object> parseMap(String json) {
        try {
            return (Map)this.getObjectMapper().readValue(json, MAP_TYPE);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot parse JSON", ex);
        }
    }

    @Override
    public List<Object> parseList(String json) {
        try {
            return (List)this.getObjectMapper().readValue(json, LIST_TYPE);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot parse JSON", ex);
        }
    }

    private ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        return this.objectMapper;
    }

    private static class ListTypeReference
    extends TypeReference<List<Object>> {
        private ListTypeReference() {
        }
    }

    private static class MapTypeReference
    extends TypeReference<Map<String, Object>> {
        private MapTypeReference() {
        }
    }
}

