/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.web.servlet;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Registration;
import org.qubership.profiler.shaded.org.springframework.boot.web.servlet.ServletContextInitializer;
import org.qubership.profiler.shaded.org.springframework.core.Conventions;
import org.qubership.profiler.shaded.org.springframework.core.Ordered;
import org.qubership.profiler.shaded.org.springframework.util.Assert;

public abstract class RegistrationBean
implements ServletContextInitializer,
Ordered {
    private String name;
    private int order = Integer.MAX_VALUE;
    private boolean asyncSupported = true;
    private boolean enabled = true;
    private Map<String, String> initParameters = new LinkedHashMap<String, String>();

    public void setName(String name) {
        Assert.hasLength(name, "Name must not be empty");
        this.name = name;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setInitParameters(Map<String, String> initParameters) {
        Assert.notNull(initParameters, "InitParameters must not be null");
        this.initParameters = new LinkedHashMap<String, String>(initParameters);
    }

    public Map<String, String> getInitParameters() {
        return this.initParameters;
    }

    public void addInitParameter(String name, String value) {
        Assert.notNull(name, "Name must not be null");
        this.initParameters.put(name, value);
    }

    protected final String getOrDeduceName(Object value) {
        return this.name != null ? this.name : Conventions.getVariableName(value);
    }

    protected void configure(Registration.Dynamic registration) {
        Assert.state(registration != null, "Registration is null. Was something already registered for name=[" + this.name + "]?");
        registration.setAsyncSupported(this.asyncSupported);
        if (!this.initParameters.isEmpty()) {
            registration.setInitParameters(this.initParameters);
        }
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }
}

