/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.instrument.classloading.jboss;

import java.lang.instrument.ClassFileTransformer;
import org.qubership.profiler.shaded.org.springframework.instrument.classloading.LoadTimeWeaver;
import org.qubership.profiler.shaded.org.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import org.qubership.profiler.shaded.org.springframework.instrument.classloading.jboss.JBossClassLoaderAdapter;
import org.qubership.profiler.shaded.org.springframework.instrument.classloading.jboss.JBossMCAdapter;
import org.qubership.profiler.shaded.org.springframework.instrument.classloading.jboss.JBossModulesAdapter;
import org.qubership.profiler.shaded.org.springframework.util.Assert;
import org.qubership.profiler.shaded.org.springframework.util.ClassUtils;

public class JBossLoadTimeWeaver
implements LoadTimeWeaver {
    private final JBossClassLoaderAdapter adapter;

    public JBossLoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public JBossLoadTimeWeaver(ClassLoader classLoader) {
        Assert.notNull(classLoader, "ClassLoader must not be null");
        this.adapter = classLoader.getClass().getName().startsWith("org.jboss.modules") ? new JBossModulesAdapter(classLoader) : new JBossMCAdapter(classLoader);
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        this.adapter.addTransformer(transformer);
    }

    @Override
    public ClassLoader getInstrumentableClassLoader() {
        return this.adapter.getInstrumentableClassLoader();
    }

    @Override
    public ClassLoader getThrowawayClassLoader() {
        return new SimpleThrowawayClassLoader(this.getInstrumentableClassLoader());
    }
}

