/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.agent;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.qubership.profiler.agent.DumpRootResolverAgent;
import org.qubership.profiler.agent.ESCLogger;
import org.qubership.profiler.agent.PluginClassLoader;
import org.qubership.profiler.agent.ProfilerTransformerPlugin;
import org.qubership.profiler.agent.TwoPhaseInit;

public class Bootstrap {
    public static final List<String> BOOT_PACKAGES = Arrays.asList("org.qubership.profiler.agent", "org.qubership.profiler.agent.http");
    private static Instrumentation inst;
    private static final Map<Class, Object> plugins;
    private static final ESCLogger logger;
    private static int JAVA_VERSION;

    public static void info(String x) {
        if (DumpRootResolverAgent.VERBOSE) {
            logger.info(x);
        }
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        File lib;
        File[] jars;
        if (Bootstrap.inst != null) {
            logger.fine("Profiler: it looks like you have specified javaagent:profiler-agent.jar option twice. Second one will not work");
            return;
        }
        Bootstrap.addJBossModulesSystemPkg();
        Bootstrap.inst = inst;
        List<String> plugins = Bootstrap.split(agentArgs);
        if (plugins.isEmpty() && (jars = (lib = new File(DumpRootResolverAgent.PROFILER_HOME, "lib")).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        })) != null) {
            plugins = new ArrayList<String>();
            for (File jar : jars) {
                plugins.add(jar.getAbsolutePath());
            }
        }
        if (plugins.isEmpty()) {
            throw new IllegalArgumentException("Profiler: bootstrap argument was not specified and was not autodetected. To specify jars explicitly, please use comma separated list as follows: -javaagent:full/path/to/profiler.jar=lib/a.jar,lib/b.jar");
        }
        Bootstrap.loadPlugins(plugins);
        ProfilerTransformerPlugin tr = Bootstrap.getPlugin(ProfilerTransformerPlugin.class);
        if (tr == null) {
            logger.fine("Profiler: no profiling transformer loaded. Total number of loaded plugins is " + plugins.size());
        } else {
            logger.info("Profiler: initialized, version " + Bootstrap.getImplementationVersion(tr.getClass()));
        }
    }

    private static void addJBossModulesSystemPkg() {
        String pkgs = System.getProperty("jboss.modules.system.pkgs");
        String profilerPackage = Bootstrap.class.getPackage().getName();
        if (pkgs == null) {
            pkgs = profilerPackage;
        } else {
            pkgs = pkgs + "," + profilerPackage;
            pkgs = pkgs.replace("org.qubership.profiler,", "");
        }
        System.setProperty("jboss.modules.system.pkgs", pkgs);
    }

    private static List<String> split(String args) {
        if (args == null) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(args, ",");
        while (stringTokenizer.hasMoreTokens()) {
            res.add(stringTokenizer.nextToken());
        }
        return res;
    }

    private static boolean pluginSupported(String jarName) {
        if (jarName.endsWith("reactor-instrument.jar") && JAVA_VERSION < 8) {
            logger.fine("plugin " + jarName + " is not supported");
            return false;
        }
        return true;
    }

    private static void loadPlugins(List<String> plugins) {
        List<String> ordered = Bootstrap.sortPlugins(plugins);
        ArrayList<Object> impls = new ArrayList<Object>();
        String lib = new File(DumpRootResolverAgent.PROFILER_HOME).getAbsolutePath();
        for (String string : ordered) {
            try {
                if (!Bootstrap.pluginSupported(string)) continue;
                if (string.endsWith(".class")) {
                    Bootstrap.callMain(string.substring(0, string.length() - 6));
                    continue;
                }
                if (string.endsWith(".jar")) {
                    PluginClassLoader loader;
                    if (string.endsWith("reactor-instrument.jar")) {
                        Instrumentation instrumentation = Bootstrap.getInstrumentation();
                        instrumentation.appendToSystemClassLoaderSearch(new JarFile(string));
                    }
                    if ((loader = PluginClassLoader.newInstance(string)) != null) {
                        Bootstrap.info("Profiler: loading " + string.replace(lib, "$esc"));
                        impls.addAll(loader.startPlugin());
                        continue;
                    }
                    if (string.endsWith("agent.jar") || string.endsWith("boot.jar")) continue;
                    Bootstrap.info("Profiler: jar " + string + " was skipped since it does not contain entry points");
                    continue;
                }
                logger.warning("Profiler: unknown argument " + string + ". Expecting *.class or *.jar");
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to load plugin " + string, e);
            }
        }
        for (String string : impls) {
            if (!(string instanceof TwoPhaseInit)) continue;
            try {
                ((TwoPhaseInit)((Object)string)).start();
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to start plugin " + string, e);
            }
        }
    }

    private static List<String> sortPlugins(List<String> plugins) {
        if (plugins.size() < 2) {
            return plugins;
        }
        ArrayList<String> res = new ArrayList<String>(plugins);
        Collections.sort(res, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.endsWith("runtime.jar") ? -1 : (o2.endsWith("runtime.jar") ? 1 : o1.compareTo(o2));
            }
        });
        return res;
    }

    private static void callMain(String className) {
        try {
            logger.fine("Profiler: about to invoke main method on class " + className);
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            if (systemClassLoader == null) {
                logger.warning("Profiler: system classloader not found. Execution of " + className + " is skipped");
                return;
            }
            Class<?> aClass = systemClassLoader.loadClass(className);
            Method main = aClass.getMethod("main", String[].class);
            main.invoke(null, new Object[]{null});
        }
        catch (ClassNotFoundException e) {
            logger.severe("Profiler: Unable to load class " + className + " as it is not found");
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.SEVERE, "Profiler: Unable to find main(String[]) method in class " + className, e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "Profiler: Unable to invoke main(String[]) method in class " + className, e);
        }
    }

    public static Instrumentation getInstrumentation() {
        return inst;
    }

    public static <T> void registerPlugin(Class<T> type, T value) {
        plugins.put(type, value);
    }

    public static <T> T getPlugin(Class<T> type) {
        return (T)plugins.get(type);
    }

    public static <T> T getPluginOrNull(Class<?> type, Class<T> interfaceType) {
        Object intended = Bootstrap.getPlugin(type);
        if (intended == null || !interfaceType.isAssignableFrom(intended.getClass())) {
            return null;
        }
        return (T)intended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImplementationVersion(Class klass) {
        ProtectionDomain pd = klass.getProtectionDomain();
        if (pd == null) {
            return "unknown (no protection domain)";
        }
        CodeSource cs = pd.getCodeSource();
        if (cs == null) {
            return "unknown (no code source)";
        }
        URL loc = cs.getLocation();
        if (loc == null) {
            return "unknown (no location)";
        }
        JarInputStream is = null;
        try {
            is = new JarInputStream(loc.openStream());
            Manifest man = is.getManifest();
            if (man == null) {
                String string = "unknown (no manifest)";
                return string;
            }
            Attributes attr = man.getMainAttributes();
            String string = attr.getValue("Implementation-Version") + ", build date " + attr.getValue("Build-Time");
            return string;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "", e);
            String string = "unknown (unable to read manifest)";
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        plugins = new HashMap<Class, Object>();
        logger = ESCLogger.getLogger(Bootstrap.class, DumpRootResolverAgent.VERBOSE ? Level.FINE : ESCLogger.ESC_LOG_LEVEL);
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        try {
            JAVA_VERSION = Integer.parseInt(version);
        }
        catch (NumberFormatException e) {
            logger.severe("Failed to parse java version from string " + version, e);
            JAVA_VERSION = -1;
        }
        logger.fine("Java version is determined to be " + JAVA_VERSION);
    }
}

