/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.agent;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import org.qubership.profiler.agent.Bootstrap;
import org.qubership.profiler.agent.ProfilerData;

public class FindJMXImplementation {
    public static String[] find() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        String cpuMonitoringClass = "org.qubership.profiler.agent.ThreadJMXCpuEmpty";
        try {
            if (ProfilerData.THREAD_CPU && threadMXBean.isCurrentThreadCpuTimeSupported()) {
                cpuMonitoringClass = "org.qubership.profiler.agent.ThreadJMXCpu";
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        String waitMonitoringClass = "org.qubership.profiler.agent.ThreadJMXWaitEmpty";
        try {
            if (ProfilerData.THREAD_WAIT && threadMXBean.isThreadContentionMonitoringSupported()) {
                if (!threadMXBean.isThreadContentionMonitoringEnabled()) {
                    threadMXBean.setThreadContentionMonitoringEnabled(true);
                }
                if (threadMXBean.isThreadContentionMonitoringEnabled()) {
                    waitMonitoringClass = "org.qubership.profiler.agent.ThreadJMXWait";
                }
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        String memoryMonitoringClass = "org.qubership.profiler.agent.ThreadJMXMemoryEmpty";
        if (ProfilerData.THREAD_MEMORY) {
            try {
                Method getThreadAllocatedBytes = threadMXBean.getClass().getMethod("getThreadAllocatedBytes", Long.TYPE);
                getThreadAllocatedBytes.setAccessible(true);
                Long bytes = (Long)getThreadAllocatedBytes.invoke((Object)threadMXBean, Thread.currentThread().getId());
                if (bytes != null) {
                    memoryMonitoringClass = "org.qubership.profiler.agent.ThreadJMXMemory";
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Bootstrap.info("Profiler: using the following thread jmx monitors: " + cpuMonitoringClass + ", " + waitMonitoringClass + ", " + memoryMonitoringClass);
        return new String[]{cpuMonitoringClass, waitMonitoringClass, memoryMonitoringClass};
    }
}

