/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.cli;

import java.io.File;
import java.io.FileFilter;
import org.qubership.profiler.cli.Command;
import org.qubership.profiler.dump.DumpRootResolver;
import org.qubership.profiler.servlet.SpringBootInitializer;
import org.qubership.profiler.shaded.net.sourceforge.argparse4j.inf.Namespace;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;

public class ListServers
implements Command {
    public static final Logger log = LoggerFactory.getLogger(ListServers.class);
    protected static final FileFilter DIRECTORY_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };

    protected void setupDumpRoot(Namespace args) {
        String dumpRoot = args.getString("dump_root");
        if (dumpRoot != null) {
            File root = new File(dumpRoot);
            if ("dump".equals(root.getName())) {
                dumpRoot = dumpRoot + File.separatorChar + "default";
            } else if (new File(root, "dump").exists()) {
                dumpRoot = dumpRoot + File.separatorChar + "dump" + File.separatorChar + "default";
            }
            DumpRootResolver.dumpRoot = dumpRoot;
        }
    }

    protected File getDumpRoot() {
        return new File(DumpRootResolver.dumpRoot).getParentFile();
    }

    @Override
    public int accept(Namespace args) {
        this.setupDumpRoot(args);
        SpringBootInitializer.init();
        File dumpRoot = this.getDumpRoot();
        if (dumpRoot == null) {
            log.warn("No dump path found - {}. Please check path to ESC dump (--dump-root)", (Object)DumpRootResolver.dumpRoot);
            return -2;
        }
        File[] servers = dumpRoot.listFiles(DIRECTORY_FILTER);
        if (servers == null || servers.length == 0) {
            log.warn("No servers found in {}. Please check path to ESC dump (--dump-root).", (Object)dumpRoot.getAbsolutePath());
            return -2;
        }
        for (File server : servers) {
            log.info("Server: {}", (Object)server.getName());
        }
        return 0;
    }
}

