/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.dump;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import org.qubership.profiler.agent.StringUtils;
import org.qubership.profiler.dump.DataInputStreamEx;
import org.qubership.profiler.dump.DataOutputStreamEx;
import org.qubership.profiler.dump.DumpFile;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;
import org.qubership.profiler.util.IOHelper;

public class DumpFileLog
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(DumpFileLog.class);
    public static final String CURRENT_LOG_FORMAT = "LOGFORMAT3";
    public static final String DEFAULT_NAME = "filelist.blst";
    private final File fileList;
    private DataOutputStreamEx outputStream;
    private boolean justCreated;
    private int logEntryCount;
    private int deleteEntryCount;
    private boolean hasDeletes;

    public DumpFileLog(File fileList) {
        this.fileList = fileList;
        this.logEntryCount = 0;
        this.deleteEntryCount = 0;
        if (!this.fileList.exists()) {
            try {
                this.createFile();
                this.justCreated = true;
            }
            catch (IOException e) {
                log.warn(String.format("Can't create log for dump files by path %s", this.fileList.getAbsolutePath()), e);
            }
        }
        if (!this.fileList.exists()) {
            return;
        }
        this.initWriter();
    }

    private void initWriter() {
        try {
            this.outputStream = new DataOutputStreamEx(new BufferedOutputStream(new FileOutputStream(this.fileList, true), 65536));
        }
        catch (IOException e) {
            log.warn(String.format("Error during opening output stream for dump files log '%s'", this.fileList), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile() throws IOException {
        File parent = this.fileList.getParentFile();
        if (!parent.exists()) {
            log.warn("Directory {} is absent. Create it", (Object)parent);
            parent.mkdirs();
        }
        boolean fileCreated = this.fileList.createNewFile();
        DataOutputStreamEx out = null;
        try {
            out = new DataOutputStreamEx(new BufferedOutputStream(new FileOutputStream(this.fileList), 65536));
            this.writeHeader(out);
        }
        catch (Throwable throwable) {
            IOHelper.close(out);
            throw throwable;
        }
        IOHelper.close(out);
    }

    private void writeHeader(DataOutputStreamEx outputStream) throws IOException {
        outputStream.write(CURRENT_LOG_FORMAT);
        outputStream.flush();
    }

    public Queue<DumpFile> parseIfPresent() {
        if (this.justCreated) {
            log.info("File with dump files log {} has been just created", (Object)this.fileList);
            return null;
        }
        Queue<DumpFile> result = this.readDumpFileLog();
        this.cleanup(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Queue<DumpFile> readDumpFileLog() {
        LinkedList<DumpFile> result = null;
        DataInputStreamEx inputStream = null;
        try {
            inputStream = DataInputStreamEx.openDataInputStream(this.fileList);
            String formatVersion = inputStream.readString();
            if (!CURRENT_LOG_FORMAT.equals(formatVersion)) {
                throw new IllegalArgumentException(String.format("File format '%s' is unknown", formatVersion));
            }
            LinkedList<DumpFile> dumpFiles = new LinkedList<DumpFile>();
            HashSet<DumpFile> deletedFiles = new HashSet<DumpFile>();
            String dumpRootDir = this.fileList.getParent();
            try {
                while (true) {
                    String operation = inputStream.readString(1);
                    String relativeFilePath = inputStream.readString(2000);
                    long timestamp = inputStream.readVarLong();
                    long fileSize = inputStream.readVarLong();
                    String relativeDependentFilePath = inputStream.readString(2000);
                    DumpFile dependentDumpFile = null;
                    if (!StringUtils.isBlank(relativeDependentFilePath)) {
                        dependentDumpFile = new DumpFile(new File(dumpRootDir, relativeDependentFilePath).getPath(), -1L, -1L);
                    }
                    DumpFile dumpFile = new DumpFile(new File(dumpRootDir, relativeFilePath).getPath(), fileSize, timestamp, dependentDumpFile);
                    if (Operation.DELETE.name.equals(operation)) {
                        deletedFiles.add(dumpFile);
                        continue;
                    }
                    dumpFiles.add(dumpFile);
                }
            }
            catch (EOFException e) {
                log.info("Read {} entries from file {}", (Object)dumpFiles.size(), (Object)this.fileList);
            }
            catch (OutOfMemoryError e) {
                log.warn("Got OutOfMemoryError while parsing " + this.fileList.getAbsolutePath() + ". Assuming the file is corrupted. Will rescan dump folder and write new index file.", e);
                Queue<DumpFile> queue = null;
                IOHelper.close(inputStream);
                return queue;
            }
            this.hasDeletes = !deletedFiles.isEmpty();
            dumpFiles.removeAll(deletedFiles);
            result = dumpFiles;
        }
        catch (IOException e) {
            log.warn("Can't parse file {}. Will res", (Object)this.fileList, (Object)e);
        }
        finally {
            IOHelper.close(inputStream);
        }
        return result;
    }

    public synchronized void cleanup(Queue<DumpFile> dumpFiles, boolean force) {
        if (!this.hasDeletes && !force) {
            return;
        }
        this.close();
        try {
            DataOutputStreamEx out;
            this.outputStream = out = new DataOutputStreamEx(new BufferedOutputStream(new FileOutputStream(this.fileList), 65536));
            this.writeHeader(out);
            this.logEntryCount = 0;
            this.deleteEntryCount = 0;
            if (dumpFiles != null) {
                for (DumpFile dumpFile : dumpFiles) {
                    this.writeOperation(dumpFile, Operation.ADD.name, out);
                }
            }
            this.hasDeletes = false;
        }
        catch (IOException e) {
            log.warn("Error during file dump list log cleanup", e);
        }
    }

    public void cleanup(Queue<DumpFile> dumpFiles) {
        this.cleanup(dumpFiles, false);
    }

    public void writeAddition(DumpFile file) {
        log.debug("Write addition of dump file {}", (Object)file);
        String operation = Operation.ADD.name;
        this.writeOperation(file, operation, this.outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDeletion(DumpFile file) {
        log.debug("Write deletion of dump file {}", (Object)file);
        String operation = Operation.DELETE.name;
        this.writeOperation(file, operation, this.outputStream);
        this.hasDeletes = true;
        ++this.deleteEntryCount;
        if (this.deleteEntryCount > this.logEntryCount / 2) {
            log.info("Amount of delete entries in log is {} and it is more than half of total amount of entries {}. Will cleanup log", (Object)this.deleteEntryCount, (Object)this.logEntryCount);
            DumpFileLog dumpFileLog = this;
            synchronized (dumpFileLog) {
                Queue<DumpFile> result = this.readDumpFileLog();
                this.cleanup(result);
            }
        }
    }

    private synchronized void writeOperation(DumpFile file, String operation, DataOutputStreamEx printWriter) {
        String path = file.getPath();
        String dependentFilePath = "";
        String fileListPath = this.fileList.getParentFile().getPath();
        if (!path.startsWith(fileListPath)) {
            log.warn("Dump file {} is located not above {}. Skip storing it", (Object)file, (Object)fileListPath);
            return;
        }
        path = path.substring(fileListPath.length() + 1);
        if (file.getDependentFile() != null) {
            dependentFilePath = file.getDependentFile().getPath().substring(fileListPath.length() + 1);
        }
        if (printWriter == null) {
            log.warn("Can't write in log line \"{},{},{},{}\"", operation, path, file.getTimestamp(), file.getSize());
            return;
        }
        try {
            printWriter.write(operation);
            printWriter.write(path);
            printWriter.writeVarInt(file.getTimestamp());
            printWriter.writeVarInt(file.getSize());
            printWriter.write(dependentFilePath);
            printWriter.flush();
            ++this.logEntryCount;
            this.justCreated = false;
        }
        catch (IOException e) {
            log.error("Error during writing to log file {}", (Object)this.fileList, (Object)e);
        }
    }

    @Override
    public synchronized void close() {
        IOHelper.close(this.outputStream);
        this.outputStream = null;
    }

    private static enum Operation {
        ADD("A"),
        DELETE("D");

        final String name;

        private Operation(String name) {
            this.name = name;
        }
    }
}

