/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.fetch;

import org.qubership.profiler.dom.ProfiledTreeStreamVisitor;
import org.qubership.profiler.fetch.FetchJFRDump;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.IMCType;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IItem;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IItemFilter;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IMemberAccessor;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.item.IType;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.IQuantity;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.qubership.profiler.threaddump.parser.MethodThreadLineInfo;
import org.qubership.profiler.threaddump.parser.ThreadInfo;

public class FetchJFRAllocations
extends FetchJFRDump {
    protected IMemberAccessor<IQuantity, IItem> allocationSize;
    protected IMemberAccessor<IQuantity, IItem> allocationSizeInTlab;
    protected IMemberAccessor<IMCType, IItem> allocationClass;

    public FetchJFRAllocations(ProfiledTreeStreamVisitor sv, String jfrFileName) {
        super(sv, jfrFileName);
    }

    @Override
    protected IItemFilter getIItemFilter() {
        return JdkFilters.ALLOC_ALL;
    }

    @Override
    protected void onNextItemType(IType<IItem> itemType) {
        super.onNextItemType(itemType);
        this.allocationSize = JdkAttributes.ALLOCATION_SIZE.getAccessor(itemType);
        this.allocationSizeInTlab = JdkAttributes.TLAB_SIZE.getAccessor(itemType);
        this.allocationClass = JdkAttributes.ALLOCATION_CLASS.getAccessor(itemType);
    }

    @Override
    protected void addStackTrace(IItem event, ThreadInfo threadinfo) {
        MethodThreadLineInfo allocatedObject = new MethodThreadLineInfo();
        boolean inNewTlab = "jdk.ObjectAllocationInNewTLAB".equals(event.getType().getIdentifier());
        threadinfo.value = inNewTlab ? this.allocationSizeInTlab.getMember(event).longValue() : this.allocationSize.getMember(event).longValue();
        allocatedObject.methodName = inNewTlab ? "<allocate>" : "<allocate outside tlab>";
        allocatedObject.setClassName(this.allocationClass.getMember(event).getFullName());
        threadinfo.addThreadLine(allocatedObject);
        super.addStackTrace(event, threadinfo);
    }
}

