/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.formatters.title;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.qubership.profiler.agent.ParameterInfo;
import org.qubership.profiler.agent.ProfilerData;
import org.qubership.profiler.formatters.title.Function;
import org.qubership.profiler.formatters.title.ProfilerTitleBuilder;
import org.qubership.profiler.shaded.gnu.trove.TIntObjectHashMap;
import org.qubership.profiler.shaded.org.apache.commons.lang.StringUtils;

public class TitleCommonTools {
    public static Collection<String> getParameterValues(Map<String, Integer> tagToIdMap, Object params, String name) {
        Collection parameterValues = tagToIdMap == null ? (Collection)((TIntObjectHashMap)params).get(ProfilerData.resolveTag(name)) : (Collection)((Map)params).get(tagToIdMap.get(name));
        if (parameterValues == null) {
            return Collections.EMPTY_LIST;
        }
        return parameterValues;
    }

    public static String getParameter(Map<String, Integer> tagToIdMap, Object params, String name) {
        return StringUtils.join(TitleCommonTools.getParameterValues(tagToIdMap, params, name), " ");
    }

    public static boolean addParameter(ProfilerTitleBuilder title, Map<String, Integer> tagToIdMap, Object params, String header, String parameterName, Function<Collection<String>, String> formatFunction) {
        Collection<String> values = TitleCommonTools.getParameterValues(tagToIdMap, params, parameterName);
        if (!values.isEmpty()) {
            title.append(header).append(formatFunction.apply(values));
            return true;
        }
        return false;
    }

    public static boolean addParameter(ProfilerTitleBuilder title, Map<String, Integer> tagToIdMap, Object params, String header, String parameterName) {
        return TitleCommonTools.addParameter(title, tagToIdMap, params, header, parameterName, new Function<Collection<String>, String>(){

            @Override
            public String apply(Collection<String> x) {
                String result = StringUtils.join(x, ", ");
                if (x.size() > 1) {
                    result = "[" + result + "]";
                }
                return result;
            }
        });
    }

    public static boolean addGenericParams(ProfilerTitleBuilder title, Map<String, Integer> tagToIdMap, Object params, List<ParameterInfo> defaultListParams, Set<String> skipParams) {
        boolean added = false;
        title.append(" ");
        for (ParameterInfo paramInfo : defaultListParams) {
            if (skipParams.contains(paramInfo.name) || !TitleCommonTools.addParameter(title, tagToIdMap, params, paramInfo.name + ": ", paramInfo.name)) continue;
            added = true;
            title.append(", ");
        }
        if (added) {
            title.deleteLastChars(2);
        }
        return added;
    }
}

