/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.io;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SizeParser {
    static final Pattern SIZE_EXPR = Pattern.compile("-?(\\d+)\\s*(b|k|m|g|t)?");

    public static long parseSize(String str, long def) {
        str = str.toLowerCase();
        Matcher m = SIZE_EXPR.matcher(str);
        long value = 0L;
        boolean matched = false;
        while (m.find()) {
            matched = true;
            String unit = m.group(2);
            long qty = Long.parseLong(m.group(1));
            if (unit == null || unit.length() == 0) {
                unit = "m";
            }
            switch (unit.charAt(0)) {
                case 't': {
                    qty *= 1024L;
                }
                case 'g': {
                    qty *= 1024L;
                }
                case 'm': {
                    qty *= 1024L;
                }
                case 'k': {
                    qty *= 1024L;
                }
            }
            if (m.group(0).charAt(0) == '-') {
                value -= qty;
                continue;
            }
            value += qty;
        }
        if (!matched) {
            return def;
        }
        return value;
    }
}

