/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.com.github.ziplet.filter.compression;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressingFilterContext;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressingOutputStream;
import org.qubership.profiler.shaded.com.github.ziplet.filter.compression.CompressingStreamFactory;
import org.qubership.profiler.shaded.org.slf4j.Logger;
import org.qubership.profiler.shaded.org.slf4j.LoggerFactory;

final class ThresholdOutputStream
extends OutputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThresholdOutputStream.class);
    private boolean buffering;
    private final OutputStream out1;
    private OutputStream out2;
    private CompressingOutputStream compressingOutputStream;
    private final CompressingStreamFactory compressingStreamFactory;
    private final CompressingFilterContext context;
    private final int threshold;
    private final BufferCommitmentCallback bufferCommitmentCallback;
    private ByteArrayOutputStream buffer;
    private boolean closed;
    private boolean forceOut1;

    ThresholdOutputStream(OutputStream out1, CompressingStreamFactory compressingStreamFactory, CompressingFilterContext context, BufferCommitmentCallback thresholdReachedCallback) {
        assert (out1 != null && compressingStreamFactory != null && context != null && thresholdReachedCallback != null);
        this.buffering = true;
        this.out1 = out1;
        this.compressingStreamFactory = compressingStreamFactory;
        this.context = context;
        this.threshold = context.getCompressionThreshold();
        this.bufferCommitmentCallback = thresholdReachedCallback;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        if (this.forceOut1) {
            this.out1.write(b);
        } else if (this.continueBuffering(1)) {
            assert (this.buffering);
            assert (this.buffer != null);
            this.buffer.write(b);
        } else {
            assert (!this.buffering);
            assert (this.out2 != null);
            this.out2.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.checkClosed();
        if (this.forceOut1) {
            this.out1.write(b);
        } else if (this.continueBuffering(b.length)) {
            assert (this.buffering);
            assert (this.buffer != null);
            this.buffer.write(b);
        } else {
            assert (!this.buffering);
            assert (this.out2 != null);
            this.out2.write(b);
        }
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        this.checkClosed();
        if (this.forceOut1) {
            this.out1.write(b, offset, length);
        } else if (this.continueBuffering(length)) {
            assert (this.buffering);
            assert (this.buffer != null);
            this.buffer.write(b, offset, length);
        } else {
            assert (!this.buffering);
            assert (this.out2 != null);
            this.out2.write(b, offset, length);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.forceOut1) {
            this.out1.flush();
        } else if (!this.buffering) {
            this.out2.flush();
        } else {
            LOGGER.debug("Switching to alternate stream due to flush()");
            this.switchToOutputStream2();
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.forceOut1) {
            this.out1.flush();
            this.out1.close();
        } else if (this.buffering) {
            this.forceOutputStream1();
            this.out1.flush();
            this.out1.close();
        } else {
            assert (this.out2 != null);
            assert (this.compressingOutputStream != null);
            this.out2.flush();
            this.compressingOutputStream.finish();
            this.out2.close();
        }
    }

    void reset() {
        if (this.forceOut1 || !this.buffering) {
            throw new IllegalStateException("Can't reset");
        }
        if (this.buffer != null) {
            this.buffer.reset();
        }
    }

    public String toString() {
        return "ThresholdOutputStream";
    }

    private boolean continueBuffering(int numAdditionalBytes) throws IOException {
        boolean shouldContinue = false;
        if (this.buffering) {
            if (this.buffer == null) {
                if (numAdditionalBytes >= this.threshold) {
                    this.switchToOutputStream2();
                } else {
                    this.buffer = new ByteArrayOutputStream(this.threshold);
                    shouldContinue = true;
                }
            } else if (this.buffer.size() + numAdditionalBytes >= this.threshold) {
                this.switchToOutputStream2();
            } else {
                shouldContinue = true;
            }
        }
        return shouldContinue;
    }

    void forceOutputStream1() throws IOException {
        LOGGER.debug("Forced to primary stream");
        this.forceOut1 = true;
        if (this.bufferCommitmentCallback != null) {
            this.bufferCommitmentCallback.rawStreamCommitted();
        }
        this.flushBufferToStream(this.out1);
    }

    void switchToOutputStream2() throws IOException {
        LOGGER.debug("Forced to alternate stream");
        assert (this.buffering);
        if (this.bufferCommitmentCallback != null) {
            this.bufferCommitmentCallback.compressingStreamCommitted();
        }
        this.compressingOutputStream = this.compressingStreamFactory.getCompressingStream(this.out1, this.context);
        this.out2 = this.compressingOutputStream.getCompressingOutputStream();
        this.flushBufferToStream(this.out2);
    }

    private void flushBufferToStream(OutputStream out) throws IOException {
        if (this.buffer != null) {
            this.buffer.writeTo(out);
            this.buffer = null;
        }
        this.buffering = false;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Stream is closed");
        }
    }

    static interface BufferCommitmentCallback {
        public void rawStreamCommitted();

        public void compressingStreamCommitted();
    }
}

