/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.common.collection;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.collection.IteratorToolkit;

public class FastAccessNumberMap<T>
implements Iterable<T> {
    private final int pagesUpperLimit;
    private final int pageSize;
    private Object[][] pages;
    private Map<Long, T> overflow;

    public FastAccessNumberMap() {
        this(100, 50);
    }

    public FastAccessNumberMap(int pageSize, int maxPageCount) {
        this.pagesUpperLimit = pageSize * maxPageCount;
        this.pageSize = pageSize;
        this.pages = new Object[1][];
    }

    private Object[] getPage(int pageIndex) {
        Object[] page;
        if (this.pages.length <= pageIndex) {
            this.pages = (Object[][])Arrays.copyOf(this.pages, pageIndex + 1);
        }
        if ((page = this.pages[pageIndex]) == null) {
            page = new Object[this.pageSize];
            this.pages[pageIndex] = page;
        }
        return page;
    }

    private T getLow(int index) {
        Object value;
        Object tValue = value = this.getPage(index / this.pageSize)[index % this.pageSize];
        return (T)tValue;
    }

    private void putLow(int index, T object) {
        this.getPage((int)(index / this.pageSize))[index % this.pageSize] = object;
    }

    public T get(long index) {
        if (index >= 0L && index < (long)this.pagesUpperLimit) {
            return this.getLow((int)index);
        }
        return this.getOverflowMap().get(index);
    }

    public void put(long index, T value) {
        if (index >= 0L && index < (long)this.pagesUpperLimit) {
            this.putLow((int)index, value);
        } else {
            this.getOverflowMap().put(index, value);
        }
    }

    private Map<Long, T> getOverflowMap() {
        if (this.overflow == null) {
            this.overflow = new HashMap<Long, T>();
        }
        return this.overflow;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            T next;
            Iterator<Object[]> pageIterator;
            Iterator<Object> elementIterator;
            Iterator<T> highIterator;
            {
                this.pageIterator = IteratorToolkit.of(FastAccessNumberMap.this.pages);
                this.highIterator = FastAccessNumberMap.this.overflow == null ? Collections.emptyList().iterator() : FastAccessNumberMap.this.overflow.values().iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.next == null) {
                    if (this.elementIterator == null || !this.elementIterator.hasNext()) {
                        if (this.pageIterator.hasNext()) {
                            Object[] nextPage = this.pageIterator.next();
                            if (nextPage == null) continue;
                            this.elementIterator = IteratorToolkit.of(nextPage);
                            continue;
                        }
                        if (this.highIterator.hasNext()) {
                            this.next = this.highIterator.next();
                            continue;
                        }
                        return false;
                    }
                    Object value = this.elementIterator.next();
                    this.next = value;
                }
                return true;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    Object tmp = this.next;
                    this.next = null;
                    return tmp;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

