/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.common.unit;

import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ImpreciseScaleFactor;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ScaleFactor;

public class LongScaleFactor
extends ScaleFactor {
    private final long longMultiplier;

    public LongScaleFactor(long factor) {
        this.longMultiplier = factor;
    }

    @Override
    public ScaleFactor concat(ScaleFactor innerFactor) {
        if (innerFactor.isUnity()) {
            return this;
        }
        Number multiplier = innerFactor.targetNumber(this.longMultiplier);
        if (multiplier instanceof Long) {
            return new LongScaleFactor(multiplier.longValue());
        }
        return new ImpreciseScaleFactor(multiplier);
    }

    @Override
    public ScaleFactor invertAndConcat(ScaleFactor innerFactor) {
        long innerMult;
        if (innerFactor instanceof LongScaleFactor && (innerMult = ((LongScaleFactor)innerFactor).longMultiplier) % this.longMultiplier == 0L) {
            return new LongScaleFactor(innerMult / this.longMultiplier);
        }
        return super.invertAndConcat(innerFactor);
    }

    @Override
    public ScaleFactor invert() {
        return new ImpreciseScaleFactor(1.0 / (double)this.longMultiplier);
    }

    @Override
    public boolean targetOutOfRange(double srcNumericalValue, long maxAbsValue) {
        if (srcNumericalValue >= 0.0) {
            return srcNumericalValue > (double)maxAbsValue / this.getMultiplier();
        }
        return srcNumericalValue < (double)(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL) / this.getMultiplier();
    }

    @Override
    public double targetValue(double srcNumericalValue) {
        return srcNumericalValue * (double)this.longMultiplier;
    }

    @Override
    public boolean targetOutOfRange(long srcNumericalValue, long maxAbsValue) {
        if (srcNumericalValue >= 0L) {
            return srcNumericalValue > maxAbsValue / this.longMultiplier;
        }
        return srcNumericalValue < (maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL) / this.longMultiplier;
    }

    @Override
    public long targetValue(long srcNumericalValue) {
        return this.targetFloor(srcNumericalValue);
    }

    @Override
    public long targetFloor(long srcNumericalValue) {
        if (this.targetOutOfRange(srcNumericalValue, Long.MAX_VALUE)) {
            return srcNumericalValue >= 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return srcNumericalValue * this.longMultiplier;
    }

    @Override
    public Number targetNumber(long srcNumericalValue) {
        if (!this.targetOutOfRange(srcNumericalValue, Long.MAX_VALUE)) {
            return srcNumericalValue * this.longMultiplier;
        }
        return this.targetValue((double)srcNumericalValue);
    }

    @Override
    public boolean isUnity() {
        return this.longMultiplier == 1L;
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof LongScaleFactor && this.longMultiplier == ((LongScaleFactor)other).longMultiplier;
    }

    @Override
    public int hashCode() {
        return (int)this.longMultiplier;
    }

    public String toString() {
        return String.valueOf(this.longMultiplier);
    }

    @Override
    public double getMultiplier() {
        return this.longMultiplier;
    }
}

