/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.IState;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.IStateful;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.IWritableState;

public class StatefulState
implements IState,
IStateful {
    private final String type;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final List<StatefulState> children = new ArrayList<StatefulState>(4);

    private StatefulState(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public StatefulState getChild(String type) {
        for (StatefulState child : this.children) {
            if (!child.type.equals(type)) continue;
            return child;
        }
        return null;
    }

    @Override
    public String[] getAttributeKeys() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    @Override
    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public StatefulState[] getChildren() {
        return this.children.toArray(new StatefulState[this.children.size()]);
    }

    public StatefulState[] getChildren(String type) {
        ArrayList<StatefulState> childrenOfType = new ArrayList<StatefulState>(4);
        for (StatefulState child : this.children) {
            if (!child.type.equals(type)) continue;
            childrenOfType.add(child);
        }
        return childrenOfType.toArray(new StatefulState[childrenOfType.size()]);
    }

    @Override
    public void saveTo(IWritableState state) {
        for (Map.Entry<String, String> e : this.attributes.entrySet()) {
            state.putString(e.getKey(), e.getValue());
        }
        for (StatefulState child : this.children) {
            child.saveTo(state.createChild(child.type));
        }
    }

    public static StatefulState create(IStateful state) {
        StatefulState stateRoot = new StatefulState(null);
        state.saveTo(new StatefulStateWriter(stateRoot));
        return stateRoot;
    }

    public String toString() {
        return this.type + " [" + this.children.size() + "] " + this.attributes.toString();
    }

    private static class StatefulStateWriter
    implements IWritableState {
        private final StatefulState destination;

        StatefulStateWriter(StatefulState destination) {
            this.destination = destination;
        }

        @Override
        public void putString(String key, String value) {
            this.destination.attributes.put(key, value);
        }

        @Override
        public IWritableState createChild(String type) {
            StatefulState child = new StatefulState(type);
            this.destination.children.add(child);
            return new StatefulStateWriter(child);
        }
    }
}

