/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.ChunkInfo;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.EventArrays;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.IChunkLoader;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.IChunkSupplier;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.VersionNotSupportedException;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.Chunk;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.LoaderContext;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.ChunkLoaderV0;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v1.ChunkLoaderV1;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.parser.IParserExtension;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.parser.ParserExtensionRegistry;

public final class FlightRecordingLoader {
    private static final Logger LOGGER = Logger.getLogger(FlightRecordingLoader.class.getName());
    private static final String SINGLE_THREADED_PARSER_PROPERTY_KEY = "org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.parser.singlethreaded";
    private static final int MIN_MEMORY_PER_THREAD = 314572800;
    private static final short VERSION_0 = 0;
    private static final short VERSION_1 = 1;
    private static final short VERSION_2 = 2;
    private static final byte[] FLIGHT_RECORDER_MAGIC = new byte[]{70, 76, 82, 0};

    public static EventArrays loadStream(InputStream stream, boolean hideExperimentals, boolean ignoreTruncatedChunk) throws CouldNotLoadRecordingException, IOException {
        return FlightRecordingLoader.loadStream(stream, ParserExtensionRegistry.getParserExtensions(), hideExperimentals, ignoreTruncatedChunk);
    }

    public static EventArrays loadStream(InputStream stream, List<? extends IParserExtension> extensions, boolean hideExperimentals, boolean ignoreTruncatedChunk) throws CouldNotLoadRecordingException, IOException {
        return FlightRecordingLoader.readChunks(null, extensions, FlightRecordingLoader.createChunkSupplier(stream), hideExperimentals, ignoreTruncatedChunk);
    }

    public static IChunkSupplier createChunkSupplier(final InputStream input) throws CouldNotLoadRecordingException, IOException {
        return new IChunkSupplier(){

            @Override
            public Chunk getNextChunk(byte[] reusableBuffer) throws CouldNotLoadRecordingException, IOException {
                int value = input.read();
                if (value < 0) {
                    return null;
                }
                return FlightRecordingLoader.createChunkInput(new DataInputStream(input), value, reusableBuffer);
            }
        };
    }

    public static IChunkSupplier createChunkSupplier(final RandomAccessFile input) throws CouldNotLoadRecordingException, IOException {
        return new IChunkSupplier(){

            @Override
            public Chunk getNextChunk(byte[] reusableBuffer) throws CouldNotLoadRecordingException, IOException {
                if (input.length() > input.getFilePointer()) {
                    return FlightRecordingLoader.createChunkInput(input, input.readUnsignedByte(), reusableBuffer);
                }
                return null;
            }
        };
    }

    public static IChunkSupplier createChunkSupplier(final RandomAccessFile input, Collection<ChunkInfo> chunks) throws CouldNotLoadRecordingException, IOException {
        final LinkedList<ChunkInfo> include = new LinkedList<ChunkInfo>(chunks);
        return new IChunkSupplier(){

            @Override
            public Chunk getNextChunk(byte[] reusableBuffer) throws CouldNotLoadRecordingException, IOException {
                if (include.isEmpty()) {
                    return null;
                }
                input.seek(((ChunkInfo)include.poll()).getChunkPosistion());
                return FlightRecordingLoader.createChunkInput(input, input.readUnsignedByte(), reusableBuffer);
            }
        };
    }

    private static Chunk createChunkInput(DataInput input, int firstByte, byte[] reusableBuffer) throws CouldNotLoadRecordingException, IOException {
        int i = 0;
        while (FLIGHT_RECORDER_MAGIC[i] == firstByte) {
            if (++i == FLIGHT_RECORDER_MAGIC.length) {
                return new Chunk(input, FLIGHT_RECORDER_MAGIC.length, reusableBuffer);
            }
            firstByte = input.readUnsignedByte();
        }
        throw new InvalidJfrFileException();
    }

    public static List<ChunkInfo> readChunkInfo(IChunkSupplier chunkSupplier) throws CouldNotLoadRecordingException, IOException {
        Chunk nextChunk;
        long nextChunkPos = 0L;
        ArrayList<ChunkInfo> chunks = new ArrayList<ChunkInfo>();
        byte[] buffer = new byte[]{};
        while ((nextChunk = chunkSupplier.getNextChunk(buffer)) != null) {
            ChunkInfo info = FlightRecordingLoader.getChunkInfo(nextChunk, nextChunkPos);
            nextChunk.skip(info.getChunkSize());
            buffer = nextChunk.getReusableBuffer();
            nextChunkPos += info.getChunkSize();
            chunks.add(info);
        }
        return chunks;
    }

    private static ChunkInfo getChunkInfo(Chunk nextChunk, long nextChunkPos) throws CouldNotLoadRecordingException, IOException {
        switch (nextChunk.getMajorVersion()) {
            case 0: {
                return ChunkLoaderV0.getInfo(nextChunk, nextChunkPos);
            }
            case 1: 
            case 2: {
                return ChunkLoaderV1.getInfo(nextChunk, nextChunkPos);
            }
        }
        throw new VersionNotSupportedException();
    }

    public static EventArrays readChunks(Runnable monitor, IChunkSupplier chunkSupplier, boolean hideExperimentals, boolean ignoreTruncatedChunk) throws CouldNotLoadRecordingException, IOException {
        return FlightRecordingLoader.readChunks(monitor, ParserExtensionRegistry.getParserExtensions(), chunkSupplier, hideExperimentals, ignoreTruncatedChunk);
    }

    public static EventArrays readChunks(Runnable monitor, List<? extends IParserExtension> extensions, IChunkSupplier chunkSupplier, boolean hideExperimentals, boolean ignoreTruncatedChunk) throws CouldNotLoadRecordingException, IOException {
        LoaderContext context = new LoaderContext(extensions, hideExperimentals);
        Runtime rt = Runtime.getRuntime();
        long availableMemory = rt.maxMemory() - rt.totalMemory() + rt.freeMemory();
        long maxBuffersCount = Math.min(Math.max(availableMemory / 314572800L, 1L), (long)(rt.availableProcessors() - 1));
        ExecutorService threadPool = Boolean.getBoolean(SINGLE_THREADED_PARSER_PROPERTY_KEY) ? Executors.newSingleThreadExecutor() : Executors.newCachedThreadPool();
        int chunkCount = 0;
        try {
            IChunkLoader chunkLoader;
            ExecutorCompletionService<byte[]> service = new ExecutorCompletionService<byte[]>(threadPool);
            byte[] buffer = new byte[]{};
            int outstanding = 0;
            HashSet<Long> loadedChunkTimestamps = new HashSet<Long>();
            while ((chunkLoader = FlightRecordingLoader.createChunkLoader(chunkSupplier, context, buffer, ignoreTruncatedChunk)) != null) {
                Long ts = chunkLoader.getTimestamp();
                if (loadedChunkTimestamps.contains(ts)) continue;
                loadedChunkTimestamps.add(ts);
                service.submit(chunkLoader);
                ++chunkCount;
                ++outstanding;
                Future available = service.poll();
                if (available != null) {
                    buffer = (byte[])available.get();
                    FlightRecordingLoader.sendProgress(monitor);
                    --outstanding;
                    continue;
                }
                if ((long)outstanding < maxBuffersCount) {
                    buffer = new byte[]{};
                    continue;
                }
                buffer = (byte[])service.take().get();
                FlightRecordingLoader.sendProgress(monitor);
                --outstanding;
            }
            while (outstanding > 0) {
                service.take().get();
                FlightRecordingLoader.sendProgress(monitor);
                --outstanding;
            }
            if (chunkCount == 0) {
                throw new InvalidJfrFileException("No readable chunks in recording");
            }
        }
        catch (InterruptedException e) {
            throw new CouldNotLoadRecordingException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof CouldNotLoadRecordingException) {
                throw (CouldNotLoadRecordingException)cause;
            }
            throw new CouldNotLoadRecordingException(cause);
        }
        finally {
            threadPool.shutdownNow();
        }
        LOGGER.fine("Loaded JFR with " + chunkCount + " chunks");
        return context.buildEventArrays();
    }

    private static void sendProgress(Runnable listener) {
        if (listener != null) {
            listener.run();
        }
    }

    private static IChunkLoader createChunkLoader(IChunkSupplier chunkSupplier, LoaderContext context, byte[] buffer, boolean ignoreTruncatedChunk) throws CouldNotLoadRecordingException, IOException {
        try {
            Chunk chunk = chunkSupplier.getNextChunk(buffer);
            if (chunk != null) {
                switch (chunk.getMajorVersion()) {
                    case 0: {
                        return ChunkLoaderV0.create(chunk, context);
                    }
                    case 1: 
                    case 2: {
                        return ChunkLoaderV1.create(chunk, context);
                    }
                }
                throw new VersionNotSupportedException();
            }
        }
        catch (IOException e) {
            if (ignoreTruncatedChunk) {
                LOGGER.log(Level.INFO, "Ignoring exception while reading chunk", e);
            }
            throw e;
        }
        return null;
    }
}

