/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser;

import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.util.DataInputToolkit;

public class Chunk {
    private final DataInput input;
    private final short majorVersion;
    private final short minorVersion;
    private int position;
    private byte[] data;

    public Chunk(DataInput input, int offset, byte[] reusableBuffer) throws IOException, InvalidJfrFileException {
        this.input = input;
        this.data = reusableBuffer;
        this.position = offset;
        byte[] buffer = this.fill(offset + 4);
        this.majorVersion = DataInputToolkit.readShort(buffer, offset);
        this.minorVersion = DataInputToolkit.readShort(buffer, offset + 2);
    }

    public short getMajorVersion() {
        return this.majorVersion;
    }

    public short getMinorVersion() {
        return this.minorVersion;
    }

    public int getPosition() {
        return this.position;
    }

    public byte[] fill(long upToPosition) throws IOException, InvalidJfrFileException {
        int fillUpTo = Chunk.getArrayPosition(upToPosition);
        if (this.data.length < fillUpTo) {
            this.data = Arrays.copyOf(this.data, (int)((double)fillUpTo * 1.2));
        }
        if (fillUpTo > this.position) {
            this.input.readFully(this.data, this.position, fillUpTo - this.position);
            this.position = fillUpTo;
        }
        return this.data;
    }

    public void skip(long upToPosition) throws IOException, InvalidJfrFileException {
        int skipUpTo = Chunk.getArrayPosition(upToPosition);
        if (skipUpTo > this.position) {
            int skipped = this.input.skipBytes(skipUpTo - this.position);
            this.position += skipped;
        }
    }

    public byte[] getReusableBuffer() {
        return this.data;
    }

    private static int getArrayPosition(long pos) throws InvalidJfrFileException {
        if (pos > Integer.MAX_VALUE) {
            throw new InvalidJfrFileException();
        }
        return (int)pos;
    }
}

