/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0;

import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.ContentType;
import org.qubership.profiler.shaded.org.openjdk.jmc.common.unit.UnitLookup;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.ChunkStructure;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.IValueReader;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.Offset;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0.model.DataType;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.util.DataInputToolkit;

final class ArrayReader
implements IValueReader {
    private final IValueReader reader;
    private final ChunkStructure header;
    private static final int UNREASONABLE_ARRAY_LENGTH = 10000000;

    ArrayReader(IValueReader reader, ChunkStructure header) {
        this.reader = reader;
        this.header = header;
    }

    @Override
    public Object readValue(byte[] bytes, Offset offset, long timestamp) throws InvalidJfrFileException {
        int arraySize = ArrayReader.readArraySize(bytes, offset.get());
        offset.increase(DataType.INTEGER.getSize());
        if ((long)arraySize > this.header.getChunkSize()) {
            throw new InvalidJfrFileException("Found array larger than chunk size");
        }
        Object[] array = new Object[arraySize];
        for (int n = 0; n < arraySize; ++n) {
            array[n] = this.reader.readValue(bytes, offset, timestamp);
        }
        return array;
    }

    private static int readArraySize(byte[] data, int offset) throws InvalidJfrFileException {
        int length = DataInputToolkit.readInt(data, offset);
        if (length < 0 || length > 10000000) {
            throw new InvalidJfrFileException();
        }
        return length;
    }

    @Override
    public ContentType<?> getValueType() {
        return UnitLookup.UNKNOWN;
    }
}

