/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.v0;

import java.io.IOException;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.parser.Chunk;
import org.qubership.profiler.shaded.org.openjdk.jmc.flightrecorder.internal.util.DataInputToolkit;

class ChunkStructure {
    private final int metadataOffset;
    private final int bodyStartOffset;
    private final long chunkSize;

    ChunkStructure(Chunk input) throws InvalidJfrFileException, IOException {
        int position = input.getPosition();
        this.bodyStartOffset = position + 8;
        byte[] buffer = input.fill(this.bodyStartOffset);
        this.metadataOffset = (int)DataInputToolkit.readLong(buffer, position);
        buffer = input.fill(this.metadataOffset + 4);
        int metadataLength = DataInputToolkit.readInt(buffer, this.metadataOffset);
        this.chunkSize = this.metadataOffset + metadataLength;
    }

    int getBodyStartOffset() {
        return this.bodyStartOffset;
    }

    int getMetadataOffset() {
        return this.metadataOffset;
    }

    long getChunkSize() {
        return this.chunkSize;
    }
}

