/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.batch;

import javax.annotation.PostConstruct;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.qubership.profiler.shaded.org.apache.commons.logging.Log;
import org.qubership.profiler.shaded.org.apache.commons.logging.LogFactory;
import org.qubership.profiler.shaded.org.springframework.batch.core.configuration.annotation.BatchConfigurer;
import org.qubership.profiler.shaded.org.springframework.batch.core.explore.JobExplorer;
import org.qubership.profiler.shaded.org.springframework.batch.core.explore.support.JobExplorerFactoryBean;
import org.qubership.profiler.shaded.org.springframework.batch.core.launch.JobLauncher;
import org.qubership.profiler.shaded.org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.qubership.profiler.shaded.org.springframework.batch.core.repository.JobRepository;
import org.qubership.profiler.shaded.org.springframework.batch.core.repository.support.JobRepositoryFactoryBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.batch.BatchProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.qubership.profiler.shaded.org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.qubership.profiler.shaded.org.springframework.orm.jpa.JpaTransactionManager;
import org.qubership.profiler.shaded.org.springframework.transaction.PlatformTransactionManager;
import org.qubership.profiler.shaded.org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.qubership.profiler.shaded.org.springframework.util.StringUtils;

public class BasicBatchConfigurer
implements BatchConfigurer {
    private static final Log logger = LogFactory.getLog(BasicBatchConfigurer.class);
    private final BatchProperties properties;
    private final DataSource dataSource;
    private final EntityManagerFactory entityManagerFactory;
    private PlatformTransactionManager transactionManager;
    private final TransactionManagerCustomizers transactionManagerCustomizers;
    private JobRepository jobRepository;
    private JobLauncher jobLauncher;
    private JobExplorer jobExplorer;

    protected BasicBatchConfigurer(BatchProperties properties, DataSource dataSource, TransactionManagerCustomizers transactionManagerCustomizers) {
        this(properties, dataSource, null, transactionManagerCustomizers);
    }

    protected BasicBatchConfigurer(BatchProperties properties, DataSource dataSource, EntityManagerFactory entityManagerFactory, TransactionManagerCustomizers transactionManagerCustomizers) {
        this.properties = properties;
        this.entityManagerFactory = entityManagerFactory;
        this.dataSource = dataSource;
        this.transactionManagerCustomizers = transactionManagerCustomizers;
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public JobLauncher getJobLauncher() {
        return this.jobLauncher;
    }

    public JobExplorer getJobExplorer() throws Exception {
        return this.jobExplorer;
    }

    @PostConstruct
    public void initialize() {
        try {
            this.transactionManager = this.createTransactionManager();
            this.jobRepository = this.createJobRepository();
            this.jobLauncher = this.createJobLauncher();
            this.jobExplorer = this.createJobExplorer();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to initialize Spring Batch", ex);
        }
    }

    protected JobExplorer createJobExplorer() throws Exception {
        JobExplorerFactoryBean jobExplorerFactoryBean = new JobExplorerFactoryBean();
        jobExplorerFactoryBean.setDataSource(this.dataSource);
        String tablePrefix = this.properties.getTablePrefix();
        if (StringUtils.hasText(tablePrefix)) {
            jobExplorerFactoryBean.setTablePrefix(tablePrefix);
        }
        jobExplorerFactoryBean.afterPropertiesSet();
        return jobExplorerFactoryBean.getObject();
    }

    protected JobLauncher createJobLauncher() throws Exception {
        SimpleJobLauncher jobLauncher = new SimpleJobLauncher();
        jobLauncher.setJobRepository(this.getJobRepository());
        jobLauncher.afterPropertiesSet();
        return jobLauncher;
    }

    protected JobRepository createJobRepository() throws Exception {
        String tablePrefix;
        JobRepositoryFactoryBean factory = new JobRepositoryFactoryBean();
        factory.setDataSource(this.dataSource);
        if (this.entityManagerFactory != null) {
            logger.warn("JPA does not support custom isolation levels, so locks may not be taken when launching Jobs");
            factory.setIsolationLevelForCreate("ISOLATION_DEFAULT");
        }
        if (StringUtils.hasText(tablePrefix = this.properties.getTablePrefix())) {
            factory.setTablePrefix(tablePrefix);
        }
        factory.setTransactionManager(this.getTransactionManager());
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    protected PlatformTransactionManager createTransactionManager() {
        AbstractPlatformTransactionManager transactionManager = this.createAppropriateTransactionManager();
        if (this.transactionManagerCustomizers != null) {
            this.transactionManagerCustomizers.customize((PlatformTransactionManager)transactionManager);
        }
        return transactionManager;
    }

    private AbstractPlatformTransactionManager createAppropriateTransactionManager() {
        if (this.entityManagerFactory != null) {
            return new JpaTransactionManager(this.entityManagerFactory);
        }
        return new DataSourceTransactionManager(this.dataSource);
    }
}

