/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.batch;

import javax.sql.DataSource;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.AbstractDatabaseInitializer;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.batch.BatchProperties;
import org.qubership.profiler.shaded.org.springframework.core.io.ResourceLoader;
import org.qubership.profiler.shaded.org.springframework.util.Assert;

public class BatchDatabaseInitializer
extends AbstractDatabaseInitializer {
    private final BatchProperties properties;

    public BatchDatabaseInitializer(DataSource dataSource, ResourceLoader resourceLoader, BatchProperties properties) {
        super(dataSource, resourceLoader);
        Assert.notNull(properties, "BatchProperties must not be null");
        this.properties = properties;
    }

    @Override
    protected boolean isEnabled() {
        return this.properties.getInitializer().isEnabled();
    }

    @Override
    protected String getSchemaLocation() {
        return this.properties.getSchema();
    }

    @Override
    protected String getDatabaseName() {
        String databaseName = super.getDatabaseName();
        if ("oracle".equals(databaseName)) {
            return "oracle10g";
        }
        return databaseName;
    }
}

