/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spring.cache.HazelcastCacheManager;
import java.io.Closeable;
import java.io.IOException;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache.CacheManagerCustomizers;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.hazelcast.HazelcastConfigResourceCondition;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.hazelcast.HazelcastInstanceFactory;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Bean;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Conditional;
import org.qubership.profiler.shaded.org.springframework.context.annotation.Configuration;
import org.qubership.profiler.shaded.org.springframework.core.io.Resource;

abstract class HazelcastInstanceConfiguration {
    HazelcastInstanceConfiguration() {
    }

    private static class CloseableHazelcastCacheManager
    extends HazelcastCacheManager
    implements Closeable {
        private final HazelcastInstance hazelcastInstance;

        CloseableHazelcastCacheManager(HazelcastInstance hazelcastInstance) {
            super(hazelcastInstance);
            this.hazelcastInstance = hazelcastInstance;
        }

        @Override
        public void close() throws IOException {
            this.hazelcastInstance.shutdown();
        }
    }

    static class ConfigAvailableCondition
    extends HazelcastConfigResourceCondition {
        ConfigAvailableCondition() {
            super("spring.cache.hazelcast", "config");
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={HazelcastInstance.class})
    @Conditional(value={ConfigAvailableCondition.class})
    static class Specific {
        private final CacheProperties cacheProperties;
        private final CacheManagerCustomizers customizers;

        Specific(CacheProperties cacheProperties, CacheManagerCustomizers customizers) {
            this.cacheProperties = cacheProperties;
            this.customizers = customizers;
        }

        @Bean
        public HazelcastInstance hazelcastInstance() throws IOException {
            Resource config = this.cacheProperties.getHazelcast().getConfig();
            Resource location = this.cacheProperties.resolveConfigLocation(config);
            if (location != null) {
                return new HazelcastInstanceFactory(location).getHazelcastInstance();
            }
            return Hazelcast.newHazelcastInstance();
        }

        @Bean
        public HazelcastCacheManager cacheManager() throws IOException {
            HazelcastCacheManager cacheManager = new HazelcastCacheManager(this.hazelcastInstance());
            return this.customizers.customize(cacheManager);
        }
    }

    @Configuration
    @ConditionalOnSingleCandidate(value=HazelcastInstance.class)
    static class Existing {
        private final CacheProperties cacheProperties;
        private final CacheManagerCustomizers customizers;

        Existing(CacheProperties cacheProperties, CacheManagerCustomizers customizers) {
            this.cacheProperties = cacheProperties;
            this.customizers = customizers;
        }

        @Bean
        public HazelcastCacheManager cacheManager(HazelcastInstance existingHazelcastInstance) throws IOException {
            Resource config = this.cacheProperties.getHazelcast().getConfig();
            Resource location = this.cacheProperties.resolveConfigLocation(config);
            if (location != null) {
                HazelcastInstance cacheHazelcastInstance = new HazelcastInstanceFactory(location).getHazelcastInstance();
                return new CloseableHazelcastCacheManager(cacheHazelcastInstance);
            }
            HazelcastCacheManager cacheManager = new HazelcastCacheManager(existingHazelcastInstance);
            return this.customizers.customize(cacheManager);
        }
    }
}

