/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition;

import java.util.Map;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.qubership.profiler.shaded.org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.qubership.profiler.shaded.org.springframework.boot.cloud.CloudPlatform;
import org.qubership.profiler.shaded.org.springframework.context.annotation.ConditionContext;
import org.qubership.profiler.shaded.org.springframework.core.env.Environment;
import org.qubership.profiler.shaded.org.springframework.core.type.AnnotatedTypeMetadata;

class OnCloudPlatformCondition
extends SpringBootCondition {
    OnCloudPlatformCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map<String, Object> attributes = metadata.getAnnotationAttributes(ConditionalOnCloudPlatform.class.getName());
        CloudPlatform cloudPlatform = (CloudPlatform)((Object)attributes.get("value"));
        return this.getMatchOutcome(context.getEnvironment(), cloudPlatform);
    }

    private ConditionOutcome getMatchOutcome(Environment environment, CloudPlatform cloudPlatform) {
        String name = cloudPlatform.name();
        ConditionMessage.Builder message = ConditionMessage.forCondition(ConditionalOnCloudPlatform.class, new Object[0]);
        if (cloudPlatform.isActive(environment)) {
            return ConditionOutcome.match(message.foundExactly(name));
        }
        return ConditionOutcome.noMatch(message.didNotFind(name).atAll());
    }
}

